function [vx1,vy1,vz1 ...
         ,vx2,vy2,vz2 ...
         ,vx3,vy3,vz3 ...
         ,vx4,vy4,vz4 ...
         ,vx5,vy5,vz5 ...
         ,vx6,vy6,vz6] ...
...
    =   crv6_normal ...
...
         (x1,y1,z1 ...
         ,x2,y2,z2 ...
         ,x3,y3,z3 ...
         ,x4,y4,z4 ...
         ,x5,y5,z5 ...
         ,x6,y6,z6 ...
...
         ,al,be,ga ...
        )

%========================================
% Compute the normal vector at the nodes
% of a 6-node triangle
% using the parametric representation
%========================================

%--------
% prepare
%--------

      alc = 1.0-al;
      bec = 1.0-be;
      gac = 1.0-ga;

      alalc = al*alc;
      bebec = be*bec;
      gagac = ga*gac;

%---
% node coordinates
%---

      xxi(1) = 0.0;
      eet(1) = 0.0;

      xxi(2) = 1.0;
      eet(2) = 0.0;

      xxi(3) = 0.0;
      eet(3) = 1.0;

      xxi(4) = al;
      eet(4) = 0.0;

      xxi(5) = ga;
      eet(5) = gac;

      xxi(6) = 0.0;
      eet(6) = be;

%---
% run over the six nodes
%---

      for i=1:6

      xi  = xxi(i);
      eta = eet(i);

%-------------------------------------------
% compute xi derivatives of basis functions
%-------------------------------------------

      dph2 =  (2.0*xi-al+eta*(al-ga)/gac)/alc;
      dph3 =  eta*(be+ga-1.0)/(ga*bec);
      dph4 =  (1.0-2.0*xi-eta)/alalc;
      dph5 =  eta/gagac;
      dph6 = -eta/bebec;
      dph1 = -dph2-dph3-dph4-dph5-dph6;

%-------------------------------------------
% compute eta derivatives of basis functions
%-------------------------------------------

      pph2 =  xi*(al-ga)/(alc*gac);
      pph3 =  (2.0*eta-be+xi*(be+ga-1.0)/ga)/bec;
      pph4 = -xi/alalc;
      pph5 =  xi/gagac;
      pph6 =  (1.0-xi-2.0*eta)/bebec;
      pph1 = -pph2-pph3-pph4-pph5-pph6;

%------------------------------------
% compute xi and eta derivatives of x 
%------------------------------------

      DxDxi = x1*dph1 + x2*dph2 + x3*dph3 + x4*dph4 ...
            + x5*dph5 + x6*dph6;
      DyDxi = y1*dph1 + y2*dph2 + y3*dph3 + y4*dph4 ...
            + y5*dph5 + y6*dph6;
      DzDxi = z1*dph1 + z2*dph2 + z3*dph3 + z4*dph4 ...
            + z5*dph5 + z6*dph6;

      DxDet = x1*pph1 + x2*pph2 + x3*pph3 + x4*pph4 ...
            + x5*pph5 + x6*pph6;
      DyDet = y1*pph1 + y2*pph2 + y3*pph3 + y4*pph4 ...
            + y5*pph5 + y6*pph6;
      DzDet = z1*pph1 + z2*pph2 + z3*pph3 + z4*pph4 ...
            + z5*pph5 + z6*pph6;

%---
% compute the normal vector
% as an outer product
%---

      vnx = DyDxi * DzDet - DyDet * DzDxi;
      vny = DzDxi * DxDet - DzDet * DxDxi;
      vnz = DxDxi * DyDet - DxDet * DyDxi;

      hs = sqrt(vnx*vnx + vny*vny + vnz*vnz);

      vnx = vnx/hs;
      vny = vny/hs;
      vnz = vnz/hs;

      if(i==1)
       vx1 = vnx; vy1 = vny; vz1 = vnz;
      elseif(i==2)
       vx2 = vnx; vy2 = vny; vz2 = vnz;
      elseif(i==3)
       vx3 = vnx; vy3 = vny; vz3 = vnz;
      elseif(i==4)
       vx4 = vnx; vy4 = vny; vz4 = vnz;
      elseif(i==5)
       vx5 = vnx; vy5 = vny; vz5 = vnz;
      elseif(i==6)
       vx6 = vnx; vy6 = vny; vz6 = vnz;
      end

 end % over nodes

%-----
% done
%-----

 return
