clear all
close all

%==============================
% compute the curvature tensor
% on a six-node triangle
% from the position and normal
% vector at the vetices
%==============================

%----
% vertices on one eighth of a sphere
% of radius 'a'
%---

a = 3.4;

srt = 1/sqrt(2);
sra = srt*a;

xi  = 0.21; % example
eta = 0.12; % example

%---
% vertices
%---

x1 =   a; y1 = 0.0; z1 = 0.0;
x2 = 0.0; y2 =   a; z2 = 0.0;
x3 = 0.0; y3 = 0.0; z3 =   a;
x4 = sra; y4 = sra; z4 = 0.0;
x5 = 0.0; y5 = sra; z5 = sra;
x6 = sra; y6 = 0.0; z6 = sra;

%---
% plot the triangle
%---

figure(1)
hold on
plot3([x1,x4,x2,x5,x3,x6,x1] ...
     ,[y1,y4,y2,y5,y3,y6,y1] ...
     ,[z1,z4,z2,z5,z3,z6,z1],'k-o')
xlabel('x');
ylabel('y');
zlabel('z');

%---
% vertex unit normal
% (exact for the sphere)
%---

vx1 = 1.0; vy1 = 0.0; vz1 = 0.0;
vx2 = 0.0; vy2 = 1.0; vz2 = 0.0;
vx3 = 0.0; vy3 = 0.0; vz3 = 1.0;
vx4 = srt; vy4 = srt; vz4 = 0.0;
vx5 = 0.0; vy5 = srt; vz5 = srt;
vx6 = srt; vy6 = 0.0; vz6 = srt;

%---
% compute alpha, beta, gamma
%---

[al,be,ga] = abc ...
...
   (x1,y1,z1 ...
   ,x2,y2,z2 ...
   ,x3,y3,z3 ...
   ,x4,y4,z4 ...
   ,x5,y5,z5 ...
   ,x6,y6,z6 ...
   );

%---
% compute the curvatures
%---

[crvm,crvg] = crv6_interp ...
 ...
  (x1,y1,z1 ...
  ,x2,y2,z2 ...
  ,x3,y3,z3 ...
  ,x4,y4,z4 ...
  ,x5,y5,z5 ...
  ,x6,y6,z6 ...
 ...
  ,vx1,vy1,vz1 ...
  ,vx2,vy2,vz2 ...
  ,vx3,vy3,vz3 ...
  ,vx4,vy4,vz4 ...
  ,vx5,vy5,vz5 ...
  ,vx6,vy6,vz6 ...
 ...
  ,al,be,ga ...
  ,xi,eta ...
  );

format long
[1/a crvm;
1/a^2 crvg]
format short

  [vx1,vy1,vz1;
   vx2,vy2,vz2;
   vx3,vy3,vz3;
   vx4,vy4,vz4;
   vx5,vy5,vz5;
   vx6,vy6,vz6]

%=================
% interpolated vertex normal
% gives inferior results
%=================

   [vx1,vy1,vz1 ...
   ,vx2,vy2,vz2 ...
   ,vx3,vy3,vz3 ...
   ,vx4,vy4,vz4 ...
   ,vx5,vy5,vz5 ...
   ,vx6,vy6,vz6] ...
  ...
   = crv6_normal ...
  ...
   (x1,y1,z1 ...
   ,x2,y2,z2 ...
   ,x3,y3,z3 ...
   ,x4,y4,z4 ...
   ,x5,y5,z5 ...
   ,x6,y6,z6 ...
   ...
   ,al,be,ga ...
   );

  [vx1,vy1,vz1;
   vx2,vy2,vz2;
   vx3,vy3,vz3;
   vx4,vy4,vz4;
   vx5,vy5,vz5;
   vx6,vy6,vz6]

%---
% compute the curvatures
%---

[crvm,crvg] = crv6_interp ...
 ...
  (x1,y1,z1 ...
  ,x2,y2,z2 ...
  ,x3,y3,z3 ...
  ,x4,y4,z4 ...
  ,x5,y5,z5 ...
  ,x6,y6,z6 ...
 ...
  ,vx1,vy1,vz1 ...
  ,vx2,vy2,vz2 ...
  ,vx3,vy3,vz3 ...
  ,vx4,vy4,vz4 ...
  ,vx5,vy5,vz5 ...
  ,vx6,vy6,vz6 ...
 ...
  ,al,be,ga ...
  ,xi,eta ...
  );

 format long
 [1/a crvm;
 1/a^2 crvg]
 format short

%===========
% simplified
%===========

%---
% 4-6 vertex position
% by flat-triangle interpolation
%---

x4 = 0.5*(x1+x2); y4 = 0.5*(y1+y2); z4 = 0.5*(z1+z2);
x5 = 0.5*(x2+x3); y5 = 0.5*(y2+y3); z5 = 0.5*(z2+z3);
x6 = 0.5*(x3+x1); y6 = 0.5*(y3+y1); z6 = 0.5*(z3+z1);

figure(1)

plot3([x1,x4,x2,x5,x3,x6,x1] ...
     ,[y1,y4,y2,y5,y3,y6,y1] ...
     ,[z1,z4,z2,z5,z3,z6,z1],'r-o')

xlabel('x');
ylabel('y');
zlabel('z');

%---
% approximation:
%
% 4-6 vertex unit normal
% by interpolation
%---

vx4 = 0.5*(vx1+vx2);
vy4 = 0.5*(vy1+vy2);
vz4 = 0.5*(vz1+vz2);
norm = sqrt(vx4^2+vy4^2+vz4^2);
vx4 = vx4/norm;
vy4 = vy4/norm;
vz4 = vz4/norm;

vx5 = 0.5*(vx2+vx3);
vy5 = 0.5*(vy2+vy3);
vz5 = 0.5*(vz2+vz3);
norm = sqrt(vx5^2+vy5^2+vz5^2);
vx5 = vx5/norm;
vy5 = vy5/norm;
vz5 = vz5/norm;

vx6 = 0.5*(vx3+vx1);
vy6 = 0.5*(vy3+vy1);
vz6 = 0.5*(vz3+vz1);
norm = sqrt(vx6^2+vy6^2+vz6^2);
vx6 = vx6/norm;
vy6 = vy6/norm;
vz6 = vz6/norm;

%---
% recompute alpha, beta,gamma
%---

[al,be,ga] = abc ...
...
 (x1,y1,z1 ...
 ,x2,y2,z2 ...
 ,x3,y3,z3 ...
 ,x4,y4,z4 ...
 ,x5,y5,z5 ...
 ,x6,y6,z6 ...
 );

%---
% compute the curvature
%---

[crvm,crvg] = crv6_interp ...
 ...
  (x1,y1,z1 ...
  ,x2,y2,z2 ...
  ,x3,y3,z3 ...
  ,x4,y4,z4 ...
  ,x5,y5,z5 ...
  ,x6,y6,z6 ...
 ...
  ,vx1,vy1,vz1 ...
  ,vx2,vy2,vz2 ...
  ,vx3,vy3,vz3 ...
  ,vx4,vy4,vz4 ...
  ,vx5,vy5,vz5 ...
  ,vx6,vy6,vz6 ...
 ...
  ,al,be,ga ...
  ,xi,eta ...
  );

 format long
 [1/a crvm;
 1/a^2 crvg]
 format short
