clear all
close all

%---
% the eigenvalues of kappa are the
% principal curvatures
%---

kappa1  =  1.4; % arbitrary
kappa2  = -0.2; % arbitrary
kappa12 =  3.0; % arbitrary

kappa = [kappa1,  kappa12;
         kappa12, kappa2];

%---
% principal curvatures
%---

kappap = eig(kappa);

b = (kappa1-kappa2)/kappa12;
disc = sqrt(b^2+4);
lam1 = (-b-disc)/2;
lam2 = (-b+disc)/2;

kappap1 = (kappa1+lam1^2*kappa2+lam1*2*kappa12)/(1+lam1^2);
kappap2 = (kappa1+lam2^2*kappa2+lam2*2*kappa12)/(1+lam2^2);

[kappap(1), kappap(2);
 kappap1, kappap2]

