clear all
close all

%---
% compute the Gaussian curvature
% by two methods
%---

tmax = [ 0.1, 0.4, 0.8]; % arbitrary
tmin = [ 0.9, 0.5, 0.0]; % arbitrary
tmp = -(0.1*0.9+0.4*0.5)/0.8;
tmin = [ 0.9, 0.5, tmp]; % arbitrary

tmax = tmax/sqrt(tmax(1)^2+tmax(2)^2+tmax(3)^2);
tmin = tmin/sqrt(tmin(1)^2+tmin(2)^2+tmin(3)^2);

%---
% normal vector
%---

n(1) = tmax(2)*tmin(3)-tmax(3)*tmin(2);
n(2) = tmax(3)*tmin(1)-tmax(1)*tmin(3);
n(3) = tmax(1)*tmin(2)-tmax(2)*tmin(1);

kmax = 2.1;
kmin = 1.3;

knor = 1.235;

for i=1:3
 for j=1:3
  K(i,j) = kmax*tmax(i)*tmax(j) ...
         + kmin*tmin(i)*tmin(j) ...
         + knor*n(i)*n(j);
 end
end

det(K)/knor
kmax*kmin
