clear all
close all

%===============
% confirm the Green's function
% of the convection--diffusion equation
% for steady simple shear flow,
% as discussed in the text
%===============

%---
% set parameters
%---

a = 1.123433;
D = 4.2281;
xi = 0.3;
et = 0.2;
t = 0.123;

Dxi = 0.02;
Det = 0.02;
Dt  = 0.00005;

%---
% time derivative
%---

f77 = Qshear(xi,et,a,t+Dt,D);
f66 = Qshear(xi,et,a,t-Dt,D);

dQdt = (f77-f66)/(2*Dt);

%---
% Laplacian by finite differences
%---

f00 = Qshear(xi,    et,a,t,D);
f10 = Qshear(xi+Dxi,et,    a,t,D);
f90 = Qshear(xi-Dxi,et,    a,t,D);
f01 = Qshear(xi,    et+Det,a,t,D);
f09 = Qshear(xi,    et-Det,a,t,D);
f11 = Qshear(xi+Dxi,et+Det,a,t,D);
f99 = Qshear(xi-Dxi,et-Det,a,t,D);
f19 = Qshear(xi+Dxi,et-Det,a,t,D);
f91 = Qshear(xi-Dxi,et+Det,a,t,D);

%---
% Laplacian of f
%---

Qxixi = (f10-2*f00+f90)/Dxi^2;
Qetet = (f01-2*f00+f09)/Det^2;
Qxiet = (f11+f99-f19-f91)/(4.0*Dxi*Det);

at = a*t;
LaplQ = (1.0+at^2)*Qxixi - 2.0*at*Qxiet + Qetet;
LaplQ = D*LaplQ;

%---
% should be equal
%---

dQdt
LaplQ
