function Q = Qshear(xi,et,a,t,D);

%===============
% Green's function
% of the convection--diffusion equation
% for steady simple shear flow
%===============

at = a*t;

 Q = 1.0/( 4*pi*D*t*sqrt(1+at^2/12.0) ) ...
  *exp( -0.25/(D*t)*( (xi+0.5*et*at)^2 /(1+at^2/12) + et^2 ));

%L = 2*t *[1+1/3*at^2, -0.5*at;
%         -0.5*at, 1];
%invL = inv(L);
%detL = det(L);
%bxi = [xi, et];
%Q1 = 1/(2*pi*D*sqrt(detL)) * exp(-0.5/k * bxi*invL*bxi');
%[Q, Q1]

return

