function f = perimeter(N1,N2,fin)

%==================
% compute perimeter values
% around a rectangle
% by one-sided interpolation
%==================

 f = fin;

 for i=2:N1
  f(i,1) = 2.0*f(i,2)-f(i,3);
  f(i,N2+1) = 2.0*f(i,N2)-f(i,N2-1);
 end

 for j=2:N2
  f(1,j) = 2.0*f(2,j)-f(3,j);
  f(N1+1,j) = 2.0*f(N1,j)-f(N1-1,j);
 end

%---
% corner values
%---

 f(1,1) = 0.5*(2*f(2,1)-f(3,1)+2*f(1,2)-f(1,3));
 f(N1+1,1) = 0.5*(2*f(N1,1)-f(N1-1,1)+2*f(N1+1,2)-f(N1+1,3));
 f(1,N2+1) = 0.5*(2*f(1,N2)-f(1,N2-1)+2*f(2,N2+1)-f(3,N2+1));
 f(N1+1,N2+1) = 0.5*(2*f(N1+1,N2)-f(N1+1,N2-1)+2*f(N1,N2+1)-f(N1-1,N2+1));

%---
% done
%---

return
