clear all
close all

%=============================
% Solution of Poisson equation 
% inside an oblique unit cell
% by a finite-difference method
%=============================

%---
% input
%---

 phi = 0.25*pi;

 ax =-1.0;
 bx = 1.0;

 ay =-1.0;
 by = 1.0;

 Nx = 16;
 Ny = 16;

 beta = tan(phi);

%--------------------
% boundary conditions
% and source term
%--------------------

  for j=1:Ny+1
    w(j) = 0.0;  % example
    q(j) = 0.0;  % example
  end

  for i=1:Nx+1
    z(i) = 0.0;  % example
    v(i) = 0.0;  % example
  end

  for i=1:Nx+1
    for j=1:Ny+1
      source(i,j) = 10.0; % example
    end
  end

%---------------------------
% generate the linear system
%---------------------------

  [mats,mat,rhs] = pois_fds_DDDD  ...
             ...
   (ax,bx ...
   ,ay,by ...
   ,beta ...
   ,Nx,Ny ...
   ,source ...
   ,w,q,z,v ...
   );

%-----------------
% printing session
%-----------------

%  mat

%---
% solution
%---

  sol = rhs/mat';

%---
% distribute the solution
%---

 p = 0;     % counter

  for j=2:Ny
   for i=2:Nx
     p = p+1;
     f(i,j) = sol(p);
   end
  end

  for j=1:Ny+1
    f(   1,j) = w(j);
    f(Nx+1,j) = q(j);
  end

  for i=1:Nx+1
    f(i,   1) = z(i);
    f(i,Ny+1) = v(i);
  end

%---
% physical grid
%---

  Dx = (bx-ax)/Nx;
  Dy = (by-ay)/Ny;

 for j=1:Ny+1
   for i=1:Nx+1
     xincl = ax + (i-1.0)*Dx;
     yincl = ay + (j-1.0)*Dy;
     xphys(i,j) = xincl + beta*yincl;
     yphys(i,j) = yincl;
   end
 end

%---
% plot
%---

%surf(xphys,yphys,f)
mesh(xphys,yphys,f)
%axis([0 2 0 1 0 0.1])
axis equal
box on
xlabel('x','fontsize',15)
ylabel('y','fontsize',15)
zlabel('f','fontsize',15)
set(gca,'fontsize',15)
view(13,38)
