clear all
close all

%============================
% draw curvilinear coordinates
% for x1 in [0 1]
% and x2 in [0 1]
%
% for the example discussed
% in the book, as shown
% in Figure 3.1.2
%============================

alpha = 0.1;
beta = 1.0;
gamma = 2;

N1 = 2*12;
N2 = 2*8;

%---
% prepare
%---

Dx1 = 1.0/N1;
Dx2 = 1.0/N2;

for i=1:N1+1
 x1(i) = (i-1.0)*Dx1;
end

for j=1:N2+1
 x2(j) = (j-1.0)*Dx2;
end

for j=1:N2+1
 for i=1:N1+1
  xi = x1(i);
  et = x2(j);
  x(i,j) = 2.0*pi*(xi+alpha*et^2);
  y(i,j) = (1.0-beta*xi*et)*cos(2*pi*xi) + gamma*et;
 end
end

%-------
% plot the grid in the x1-x2 plane
%-------

figure(1)
hold on
xlabel('x^1','fontsize',15)
ylabel('x^2','fontsize',15)
set(gca,'fontsize',15)
box on
axis equal
axis([0 1 0 1])

for j=1:N2+1
 for i=1:N1+1
  x1grid(i,j) = x1(i);
  x2grid(i,j) = x2(j);
 end
end

for j=1:N2+1
  plot(x1grid(1:N1+1,j),x2grid(1:N1+1,j),'k')
end

for i=1:N1+1
  plot(x1grid(i,1:N2+1),x2grid(i,1:N2+1),'k')
end

%---
% plot the grid in the xy plane
%---

figure(2)
hold on
xlabel('x/L','fontsize',15)
ylabel('y/L','fontsize',15)
set(gca,'fontsize',15)
box on
axis equal
axis([-0.5 7.5 -1.25 3.25])

for j=1:N2+1
  plot(x(:,j),y(:,j),'k')
end
for i=1:N1+1
  plot(x(i,:),y(i,:),'k')
end

%---
% covariant base vectors
%---

for j=1:N2+1
 for i=1:N1+1
  xi = x1(i);
  et = x2(j);
  gcov1_x(i,j) = 2*pi;
  gcov1_y(i,j) =  -beta*et*cos(2*pi*xi) ...
               -2*pi*(1.0-beta*xi*et)*sin(2*pi*xi);
  gcov2_x(i,j) =  4.0*pi*alpha*et;
  gcov2_y(i,j) = -beta*xi*cos(2*pi*xi) + gamma;
 end
end

%---
% plot the covariant base vectors
%---

iplot31 = 0;
iplot31 = 1;

if(iplot31==1)

figure(31)
hold on
xlabel('x/L','fontsize',15)
ylabel('y/L','fontsize',15)
set(gca,'fontsize',15)
box on
axis equal
axis([-0.5 7.5 -1.25 3.25])

fc = 0.75*Dx1;

for j=1:N2+1
 for i=1:N1+1
  arrx = fc*gcov1_x(i,j);
  arry = fc*gcov1_y(i,j);
  gaidaros = arrow_cp(x(i,j),y(i,j),arrx,arry);
  plot(gaidaros(:,1), gaidaros(:,2),'k')
  arrx = fc*gcov2_x(i,j);
  arry = fc*gcov2_y(i,j);
  gaidaros = arrow_cp(x(i,j),y(i,j),arrx,arry);
  plot(gaidaros(:,1), gaidaros(:,2),'k')
 end
end

end

%---
% metric coefficients
%---

for j=1:N2+1
 for i=1:N1+1
  covmet11(i,j) = gcov1_x(i,j)*gcov1_x(i,j) ...
                + gcov1_y(i,j)*gcov1_y(i,j);
  covmet12(i,j) = gcov1_x(i,j)*gcov2_x(i,j) ...
                + gcov1_y(i,j)*gcov2_y(i,j);
  covmet21(i,j) = covmet12(i,j);
  covmet22(i,j) = gcov2_x(i,j)*gcov2_x(i,j) ...
                + gcov2_y(i,j)*gcov2_y(i,j);
  covg(i,j) = covmet11(i,j)*covmet22(i,j)-covmet12(i,j)^2;
  srcovg(i,j) = sqrt(covg(i,j));

  covmet = [ covmet11(i,j), covmet12(i,j);...
             covmet21(i,j), covmet22(i,j)];

  invcovmet = inv(covmet);

  conmet11(i,j) = invcovmet(1,1);
  conmet12(i,j) = invcovmet(1,2);
  conmet21(i,j) = invcovmet(2,1);
  conmet22(i,j) = invcovmet(2,2);
  cong(i,j) = conmet11(i,j)*conmet22(i,j)-conmet12(i,j)^2;

  conmet = [ conmet11(i,j), conmet12(i,j);...
             conmet21(i,j), conmet22(i,j)];

 end
end

%---
% contravariant base vectors
%---

for j=1:N2+1
 for i=1:N1+1
  gcon1_x(i,j) = ( covmet22(i,j)*gcov1_x(i,j) ...
                  -covmet12(i,j)*gcov2_x(i,j))/covg(i,j);
  gcon1_y(i,j) = ( covmet22(i,j)*gcov1_y(i,j) ...
                  -covmet12(i,j)*gcov2_y(i,j))/covg(i,j);
  gcon2_x(i,j) = (-covmet12(i,j)*gcov1_x(i,j) ...
                  +covmet11(i,j)*gcov2_x(i,j))/covg(i,j);
  gcon2_y(i,j) = (-covmet12(i,j)*gcov1_y(i,j) ...
                  +covmet11(i,j)*gcov2_y(i,j))/covg(i,j);
% p11 = gcov1_x(i,j)*gcon1_x(i,j)+gcov1_y(i,j)*gcon1_y(i,j);
% p12 = gcov1_x(i,j)*gcon2_x(i,j)+gcov1_y(i,j)*gcon2_y(i,j);
% p22 = gcov2_x(i,j)*gcon2_x(i,j)+gcov2_y(i,j)*gcon2_y(i,j);
% [p11, p12, p22]
 end
end


%---
% plot the contravariant base vectors
%---

iplot32 = 0;
iplot32 = 1;

if(iplot32==1)

figure(32)
hold on
xlabel('x/L','fontsize',15)
ylabel('y/L','fontsize',15)
set(gca,'fontsize',15)
box on
axis equal
axis([-0.5 7.5 -1.25 3.25])

fc = pi*Dx1;

for j=1:N2+1
 for i=1:N1+1
  arrx = fc*gcon1_x(i,j);
  arry = fc*gcon1_y(i,j);
  gaidaros = arrow_cp(x(i,j),y(i,j),arrx,arry);
  plot(gaidaros(:,1), gaidaros(:,2),'k')
  arrx = fc*gcon2_x(i,j);
  arry = fc*gcon2_y(i,j);
  gaidaros = arrow_cp(x(i,j),y(i,j),arrx,arry);
  plot(gaidaros(:,1), gaidaros(:,2),'k')
 end
end

end



