clear all
close all

%---
% parameters
%---

a = 2;  % x semi-axis of innermost ellipse
b = 1;  % y semi-axis of innermost ellipse

%---
% compute xi_0 and A
%---

xi0 = atanh(b/a);
snhxi0 = sinh(xi0);
cshxi0 = cosh(xi0);
A = b/snhxi0;

ximax = log(32.0*b/A);

Np = 2;
Nxi = Np*8;
Net = Np*16;

%---
% grid
%---

 Dxi = (ximax-xi0)/Nxi;

 for i=1:Nxi+1
  xi(i) = xi0+(i-1.0)*Dxi;
  snhxi(i) = sinh(xi(i));
  cshxi(i) = cosh(xi(i));
 end

 Deta = 2.0*pi/Net;

 for j=1:Net+1
  eta(j) = (j-1.0)*Deta;
  cseta(j) = cos(eta(j));
  sneta(j) = sin(eta(j));
 end

%---
% grid points
%---

 for i=1:Nxi+1
  for j=1:Net+1
   x(i,j) = A*cshxi(i)*cseta(j);
   y(i,j) = A*snhxi(i)*sneta(j);
   J(i,j) = A*sqrt(cshxi(i)^2-cseta(j)^2);
  end
 end

%---
% polar angle around the orgin (theta)
%---

 xcnt = 0.0;
 ycnt = 0.0;

 for j=1:Net+1
  rr = sqrt((x(1,j)-xcnt)^2+(y(1,j)-ycnt)^2);
  theta(j) = acos((x(1,j)-xcnt)/rr);
  if(y(1,j)<0.0)
   theta(j) = 2*pi-theta(j);
  end
 end

 theta(Net+1) = 2*pi+theta(1);

%---
% plot
%---

 figure(1)
 hold on;

 x = real(x);
 y = real(y);

 for j=1:Net+1
  plot(x(:,j),y(:,j),'k')
 end

 for i=1:Nxi+1
  plot(x(i,:),y(i,:),'r')
 end

% plot(x(1,1),y(1,1),'bo')

 xlabel('x','fontsize',15);
 ylabel('y','fontsize',15);
 set(gca,'fontsize',15)
 axis square
 axis([-5 5 -5 5])
 box on

