clear all
close all

Inormt=1;
Inormt=0;

%----------
% bcov1 and bcov2 (covariant)
%----------

thbcov1 = 0.034*pi;    % arbitrary
thbcov2 = 0.334*pi;    % arbitrary

lb1 = 1.4;  % arbitrary
lb2 = 1.8;  % arbitrary

bcov1(1) = lb1*cos(thbcov1); bcov1(2) = lb1*sin(thbcov1);
bcov2(1) = lb2*cos(thbcov2); bcov2(2) = lb2*sin(thbcov2);

%---
% bcon1 and bcon2  (contravariant)
%---

thbcon1 = thbcov2 - 0.5*pi;
thbcon2 = thbcov1 + 0.5*pi;

lc1 = 2.4; % arbitrary
lc2 = 1.2; % arbitrary

bcon1(1) = lc1*cos(thbcon1); bcon1(2) = lc1*sin(thbcon1);
bcon2(1) = lc2*cos(thbcon2); bcon2(2) = lc2*sin(thbcon2);

%---
% projections
%---

omg(1) = bcov1*bcon1';
omg(2) = bcov2*bcon2';

%---
% matrix
%---

T = [ 1 2;   % arbitrary
      3 4];
%---
% con-cov components
%---

Tnv(1,1) = bcon1*T*bcov1'/(omg(1)*omg(1));
Tnv(1,2) = bcon1*T*bcov2'/(omg(1)*omg(2));
Tnv(2,1) = bcon2*T*bcov1'/(omg(2)*omg(1));
Tnv(2,2) = bcon2*T*bcov2'/(omg(2)*omg(2));

%---
% cov-con components
%---

Tvn(1,1) = bcov1*T*bcon1'/(omg(1)*omg(1));
Tvn(1,2) = bcov1*T*bcon2'/(omg(1)*omg(2));
Tvn(2,1) = bcov2*T*bcon1'/(omg(2)*omg(1));
Tvn(2,2) = bcov2*T*bcon2'/(omg(2)*omg(2));

%---
% cov-cov components
%---

Tvv(1,1) = bcov1*T*bcov1'/(omg(1)*omg(1));
Tvv(1,2) = bcov1*T*bcov2'/(omg(1)*omg(2));
Tvv(2,1) = bcov2*T*bcov1'/(omg(2)*omg(1));
Tvv(2,2) = bcov2*T*bcov2'/(omg(2)*omg(2));

%---
% con-con components
%---

Tnn(1,1) = bcon1*T*bcon1'/(omg(1)*omg(1));
Tnn(1,2) = bcon1*T*bcon2'/(omg(1)*omg(2));
Tnn(2,1) = bcon2*T*bcon1'/(omg(2)*omg(1));
Tnn(2,2) = bcon2*T*bcon2'/(omg(2)*omg(2));

% [Tnv Tvn Tvv Tnn]

%---
% matrix H
%---

H = [ -1.2  3.3;   % arbitrary
       4.3 -1.1];

%--- tilde base is working Cartesian
%
if(Inormt==1)

 Htmp = [bcov1(1), bcov1(2) ;
         bcov2(1), bcov2(2)];
 H = inv(Htmp);

end
%--- 

Hinv = inv(H);

%---
% tilde base vectors
%---

bcovt1 = H(1,1)*bcov1 + H(1,2)*bcov2;
bcovt2 = H(2,1)*bcov1 + H(2,2)*bcov2;

%---
% contravariant tilde base vectors
% computed in terms of a matrix
%---

AMAT = [ bcovt1(1), bcovt2(1);
         bcovt1(2), bcovt2(2)];

omgtMAT = [ 1.9,  0.0;  % arbitrary
             0.0   1.4];

%-------- tilde base in working Cartesian

if(Inormt==1)
 omgtMAT = [ 1.0,  0.0;  % normalized
             0.0   1.0];
end
%-------- tilde base is working Cartesian

BMAT = inv(AMAT')*omgtMAT;

bcont1(1) = BMAT(1,1); bcont1(2) = BMAT(2,1);
bcont2(1) = BMAT(1,2); bcont2(2) = BMAT(2,2);

omgt(1) = bcovt1*bcont1';
omgt(2) = bcovt2*bcont2';

%---
% matrix R
%---

R = [bcont1*bcov1'/omg(1) bcont1*bcov2'/omg(2);
     bcont2*bcov1'/omg(1) bcont2*bcov2'/omg(2)];

Rinv = inv(R);

%---
% con-cov components
%---

Tnvt(1,1) = bcont1*T*bcovt1'/(omgt(1)*omgt(1));
Tnvt(1,2) = bcont1*T*bcovt2'/(omgt(1)*omgt(2));
Tnvt(2,1) = bcont2*T*bcovt1'/(omgt(2)*omgt(1));
Tnvt(2,2) = bcont2*T*bcovt2'/(omgt(2)*omgt(2));

%---
% cov-con components
%---

Tvnt(1,1) = bcovt1*T*bcont1'/(omgt(1)*omgt(1));
Tvnt(1,2) = bcovt1*T*bcont2'/(omgt(1)*omgt(2));
Tvnt(2,1) = bcovt2*T*bcont1'/(omgt(2)*omgt(1));
Tvnt(2,2) = bcovt2*T*bcont2'/(omgt(2)*omgt(2));

%---
% cov-cov components
%---

Tvvt(1,1) = bcovt1*T*bcovt1'/(omgt(1)*omgt(1));
Tvvt(1,2) = bcovt1*T*bcovt2'/(omgt(1)*omgt(2));
Tvvt(2,1) = bcovt2*T*bcovt1'/(omgt(2)*omgt(1));
Tvvt(2,2) = bcovt2*T*bcovt2'/(omgt(2)*omgt(2));

%---
% con-con components
%---

Tnnt(1,1) = bcont1*T*bcont1'/(omgt(1)*omgt(1));
Tnnt(1,2) = bcont1*T*bcont2'/(omgt(1)*omgt(2));
Tnnt(2,1) = bcont2*T*bcont1'/(omgt(2)*omgt(1));
Tnnt(2,2) = bcont2*T*bcont2'/(omgt(2)*omgt(2));

%---
% confirm
%---

Tconf = [Tnvt Hinv'*Tnv*Rinv;
         Tvnt Rinv'*Tvn*Hinv;
         Tvvt Rinv'*Tvv*Rinv;
         Tnnt Hinv'*Tnn*Hinv]

%---
% confirm determinants
%---

detH = det(H);
detR = det(R);

Detconf = [det(Tnvt) det(Tnv)/detR/detH;
           det(Tvnt) det(Tvn)/detR/detH;
           det(Tvvt) det(Tvv)/detR/detR;
           det(Tnnt) det(Tnn)/detH/detH] 
