clear all
close all

%----------
% covariant b
% bcov1 and bcov2
%----------

thcov1 = 0.034*pi;    % arbitrary
thcov2 = 0.334*pi;    % arbitrary

lb1 = 1.4;  % arbitrary
lb2 = 1.8;  % arbitrary

bcov1(1) = lb1*cos(thcov1); bcov1(2) = lb1*sin(thcov1);
bcov2(1) = lb2*cos(thcov2); bcov2(2) = lb2*sin(thcov2);

%---
% contravariant
% bcon1 and bcon2
%
% rotated by 90
%---

thcon1 = thcov2 - 0.5*pi;
thcon2 = thcov1 + 0.5*pi;

lc1 = 2.4; % arbitrary
lc2 = 1.2; % arbitrary

bcon1(1) = lc1*cos(thcon1); bcon1(2) = lc1*sin(thcon1);
bcon2(1) = lc2*cos(thcon2); bcon2(2) = lc2*sin(thcon2);

omg(1) = bcov1*bcon1';
omg(2) = bcov2*bcon2';

%--- normalize ---
% bcon1 = bcon1/omg(1);
% bcon2 = bcon2/omg(2);
% omg(1) = bcov1*bcon1';
% omg(2) = bcov2*bcon2';
%----------

omgmat = [ omg(1), 0.0;
           0.0,    omg(2)];

%---
% matrix F
%---

F = [ bcov1(1), bcov2(1) ;
      bcov1(2), bcov2(2) ];

%---
% matrix H  (arbitrary)
%---

H = [ -1.2  3.3; 
       4.3 -1.1];

Hinv = inv(H);

%---
% covariant
% tilded base vectors
%---

bcovt1 = H(1,1)*bcov1 + H(1,2)*bcov2;
bcovt2 = H(2,1)*bcov1 + H(2,2)*bcov2;

%---
% matrix Ftilde
%---

Ft = [ bcovt1(1), bcovt2(1) ;
       bcovt1(2), bcovt2(2) ];

%[Ft F*H']
%[F Ft*Hinv']

%---
% contravariant tilde base vectors
% computed in terms of a matrix
%---

omgtmat = [ 1.0,  0.0;  % normalized
            0.0   1.0];

omgtmat = [ 1.9,  0.0;  % arbitrary
           0.0   1.4];

Phit = inv(Ft')*omgtmat;

bcont1(1) = Phit(1,1); bcont1(2) = Phit(2,1);
bcont2(1) = Phit(1,2); bcont2(2) = Phit(2,2);

omgt(1) = bcovt1*bcont1';
omgt(2) = bcovt2*bcont2';

%---
% confirm
%---

[R omgtmat*inv(H')*inv(omgmat)]
[H omgtmat*inv(R')*inv(omgmat)]

%---
% confirm H 
%---

Hconf = [bcovt1*bcon1'/omg(1) bcovt1*bcon2'/omg(2);
         bcovt2*bcon1'/omg(1) bcovt2*bcon2'/omg(2)];

Hinvconf = [bcov1*bcont1'/omgt(1) bcov1*bcont2'/omgt(2);
            bcov2*bcont1'/omgt(1) bcov2*bcont2'/omgt(2)];

HHconf = [H Hconf]
Hinvconf = [Hinv Hinvconf]

%---
% confirm bcov
%---

bcov1conf = Hinv(1,1)*bcovt1 + Hinv(1,2)*bcovt2;
bcov2conf = Hinv(2,1)*bcovt1 + Hinv(2,2)*bcovt2;

bcovconf = [bcov1 bcov1conf;
            bcov2 bcov2conf]

%---
% matrix R
%---

R = [bcont1*bcov1'/omg(1) bcont1*bcov2'/omg(2);
     bcont2*bcov1'/omg(1) bcont2*bcov2'/omg(2)];

Rinvconf = [bcon1*bcovt1'/omgt(1) bcon1*bcovt2'/omgt(2);
            bcon2*bcovt1'/omgt(1) bcon2*bcovt2'/omgt(2)];

Rinv = inv(R);
RRinvconf = [Rinv Rinvconf]

%---
% arbitrary vector
%---

v = [1.1, -2.1]; 

%---
% vector components
%---

vcon1 = v*bcon1'/omg(1);
vcon2 = v*bcon2'/omg(2);

vcont1 = v*bcont1'/omgt(1);
vcont2 = v*bcont2'/omgt(2);

vcov1 = v*bcov1'/omg(1);
vcov2 = v*bcov2'/omg(2);

vcovt1 = v*bcovt1'/omgt(1);
vcovt2 = v*bcovt2'/omgt(2);

%---
% confirm the transformation rules
%---

vvcont = [vcont1, Hinv(1,1)*vcon1+Hinv(2,1)*vcon2;
          vcont2, Hinv(1,2)*vcon1+Hinv(2,2)*vcon2]

vvcon  = [vcon1, H(1,1)*vcont1+H(2,1)*vcont2;
          vcon2, H(1,2)*vcont1+H(2,2)*vcont2]

vvcovt = [vcovt1, Rinv(1,1)*vcov1+Rinv(2,1)*vcov2;
          vcovt2, Rinv(1,2)*vcov1+Rinv(2,2)*vcov2]

vvcov = [vcov1, R(1,1)*vcovt1+R(2,1)*vcovt2;
         vcov2, R(1,2)*vcovt1+R(2,2)*vcovt2]

