clear all
close all

%----------
% bcov1 and bcov2 (covariant)
%----------

thbcov1 = 0.034*pi;    % arbitrary
thbcov2 = 0.334*pi;    % arbitrary

lb1 = 1.4;  % arbitrary
lb2 = 1.8;  % arbitrary

%thbcov1 = 0.000*pi;
%thbcov2 = 0.500*pi;
%lb1 = 1.0;  % arbitrary
%lb2 = 1.0;  % arbitrary

bcov1(1) = lb1*cos(thbcov1); bcov1(2) = lb1*sin(thbcov1);
bcov2(1) = lb2*cos(thbcov2); bcov2(2) = lb2*sin(thbcov2);

%---
% bcon1 and bcon2  (contravariant)
%---

thbcon1 = thbcov2 - 0.5*pi;
thbcon2 = thbcov1 + 0.5*pi;

lc1 = 2.4; % arbitrary
lc2 = 1.2; % arbitrary

%lc1 = 1.0; % arbitrary
%lc2 = 1.0; % arbitrary

bcon1(1) = lc1*cos(thbcon1); bcon1(2) = lc1*sin(thbcon1);
bcon2(1) = lc2*cos(thbcon2); bcon2(2) = lc2*sin(thbcon2);

%---
% projections omega(1) and omega(2)
%---

omg(1) = bcov1*bcon1';
omg(2) = bcov2*bcon2';

%---
% matrix
%---

T = [ 1.0 2.0;   % symmetric
      2.0 4.0];

T = [ 0.0 2.0;   % skew-symmetric
     -2.0 0.0];

T = [ 1.0 0.0;   % identity
      0.0 1.0];

T = [ 1.0 2.0;   % arbitrary
      3.0 4.0];

%---
% con-cov components
%---

Tnv(1,1) = bcon1*T*bcov1'/(omg(1)*omg(1));
Tnv(1,2) = bcon1*T*bcov2'/(omg(1)*omg(2));
Tnv(2,1) = bcon2*T*bcov1'/(omg(2)*omg(1));
Tnv(2,2) = bcon2*T*bcov2'/(omg(2)*omg(2));

%---
% cov-con components
%---

Tvn(1,1) = bcov1*T*bcon1'/(omg(1)*omg(1));
Tvn(1,2) = bcov1*T*bcon2'/(omg(1)*omg(2));
Tvn(2,1) = bcov2*T*bcon1'/(omg(2)*omg(1));
Tvn(2,2) = bcov2*T*bcon2'/(omg(2)*omg(2));

%---
% con-con components
%---

Tnn(1,1) = bcon1*T*bcon1'/(omg(1)*omg(1));
Tnn(1,2) = bcon1*T*bcon2'/(omg(1)*omg(2));
Tnn(2,1) = bcon2*T*bcon1'/(omg(2)*omg(1));
Tnn(2,2) = bcon2*T*bcon2'/(omg(2)*omg(2));

%---
% cov-cov components
%---

Tvv(1,1) = bcov1*T*bcov1'/(omg(1)*omg(1));
Tvv(1,2) = bcov1*T*bcov2'/(omg(1)*omg(2));
Tvv(2,1) = bcov2*T*bcov1'/(omg(2)*omg(1));
Tvv(2,2) = bcov2*T*bcov2'/(omg(2)*omg(2));

[Tnv Tvn Tnn Tvv]

%---
% compute covmet (b)
%---

covmet(1,1) = bcov1*bcov1';
covmet(1,2) = bcov1*bcov2';
covmet(2,1) = bcov2*bcov1';
covmet(2,2) = bcov2*bcov2';

%---
% compute Gcon (beta)
%---

conmet(1,1) = bcon1*bcon1';
conmet(1,2) = bcon1*bcon2';
conmet(2,1) = bcon2*bcon1';
conmet(2,2) = bcon2*bcon2';

%---
% lower and raise an index
%
% vn: covariant-contravariant
% nv: contravariant-covariant
%---

for m=1:2
 for n=1:2
  Tvn1(m,n) = 0.0;
  for i=1:2
   for j=1:2
    Tvn1(m,n) = Tvn1(m,n) + Tnv(i,j)*covmet(i,m)*conmet(j,n);
   end
  end
  Tvn1(m,n) = Tvn1(m,n)/(omg(m)*omg(n));
 end
end

[Tvn Tvn1]

%=============
% determinants
%=============

%---
% four matrix bases
%---

for i=1:2
 for j=1:2

  Bconcov11(i,j) = bcon1(i)*bcov1(j);
  Bconcov12(i,j) = bcon1(i)*bcov2(j);
  Bconcov21(i,j) = bcon2(i)*bcov1(j);
  Bconcov22(i,j) = bcon2(i)*bcov2(j);

  Bcovcon11(i,j) = bcov1(i)*bcon1(j);
  Bcovcon12(i,j) = bcov1(i)*bcon2(j);
  Bcovcon21(i,j) = bcov2(i)*bcon1(j);
  Bcovcon22(i,j) = bcov2(i)*bcon2(j);

  Bcovcov11(i,j) = bcov1(i)*bcov1(j);
  Bcovcov12(i,j) = bcov1(i)*bcov2(j);
  Bcovcov21(i,j) = bcov2(i)*bcov1(j);
  Bcovcov22(i,j) = bcov2(i)*bcov2(j);

  Bconcon11(i,j) = bcon1(i)*bcon1(j);
  Bconcon12(i,j) = bcon1(i)*bcon2(j);
  Bconcon21(i,j) = bcon2(i)*bcon1(j);
  Bconcon22(i,j) = bcon2(i)*bcon2(j);

 end
end

%---
% determinants
%---

A(1,1) = 0.4; % arbitrary
A(1,2) = 0.1;
A(2,1) = 0.8;
A(2,2) = 0.7;

detA = det(A);

AVV = A(1,1)*Bcovcov11+A(1,2)*Bcovcov12 ...
     +A(2,1)*Bcovcov21+A(2,2)*Bcovcov22;

ANN = A(1,1)*Bconcon11+A(1,2)*Bconcon12 ...
     +A(2,1)*Bconcon21+A(2,2)*Bconcon22;

ANV = A(1,1)*Bconcov11+A(1,2)*Bconcov12 ...
     +A(2,1)*Bconcov21+A(2,2)*Bconcov22;

AVN = A(1,1)*Bcovcon11+A(1,2)*Bcovcon12 ...
     +A(2,1)*Bcovcon21+A(2,2)*Bcovcon22;

metcov = covmet(1,1)*covmet(2,2)-covmet(1,2)^2;
metcon = conmet(1,1)*conmet(2,2)-conmet(1,2)^2;

% determinants in terms of det(A)

detomg = omg(1)*omg(2);

[det(AVV) detA*metcov;
 det(ANN) detA*metcon;
 det(ANV) detA*detomg;
 det(AVN) detA*detomg]

%===============
% matrix inverse
%===============

S = inv(T);

%---
% con-cov components
%---

Snv(1,1) = bcon1*S*bcov1'/(omg(1)*omg(1));
Snv(1,2) = bcon1*S*bcov2'/(omg(1)*omg(2));
Snv(2,1) = bcon2*S*bcov1'/(omg(2)*omg(1));
Snv(2,2) = bcon2*S*bcov2'/(omg(2)*omg(2));

%---
% cov-con components
%---

Svn(1,1) = bcov1*S*bcon1'/(omg(1)*omg(1));
Svn(1,2) = bcov1*S*bcon2'/(omg(1)*omg(2));
Svn(2,1) = bcov2*S*bcon1'/(omg(2)*omg(1));
Svn(2,2) = bcov2*S*bcon2'/(omg(2)*omg(2));

%---
% con-con components
%---

Snn(1,1) = bcon1*S*bcon1'/(omg(1)*omg(1));
Snn(1,2) = bcon1*S*bcon2'/(omg(1)*omg(2));
Snn(2,1) = bcon2*S*bcon1'/(omg(2)*omg(1));
Snn(2,2) = bcon2*S*bcon2'/(omg(2)*omg(2));

%---
% cov-cov components
%---

Svv(1,1) = bcov1*S*bcov1'/(omg(1)*omg(1));
Svv(1,2) = bcov1*S*bcov2'/(omg(1)*omg(2));
Svv(2,1) = bcov2*S*bcov1'/(omg(2)*omg(1));
Svv(2,2) = bcov2*S*bcov2'/(omg(2)*omg(2));

[Snv Svn Snn Svv]

for i=1:2
 for j=1:2
  test1(i,j) = 0.0;
  test2(i,j) = 0.0;
  test3(i,j) = 0.0;
  test4(i,j) = 0.0;
  for n=1:2
   test1(i,j) = test1(i,j)+Tvn(i,n)*Svv(n,j)*omg(n);
   test2(i,j) = test2(i,j)+Tnv(i,n)*Snn(n,j)*omg(n);
   test3(i,j) = test3(i,j)+Tnn(i,n)*Svv(n,j)*omg(n);
   test4(i,j) = test4(i,j)+Tvv(i,n)*Snn(n,j)*omg(n);
  end
  verify1(i,j) = covmet(i,j)/(omg(i)*omg(j));
  verify2(i,j) = conmet(i,j)/(omg(i)*omg(j));
 end
  verify3(i,i) = 1.0/omg(i);
  verify4(i,i) = 1.0/omg(i);
end

[test1 verify1;
 test2 verify2;
 test3 verify3;
 test4 verify4
]
