clear all
close all

%----------
% bcov1 and bcov2 (covariant)
%----------

thbcov1 = 0.034*pi;    % arbitrary
thbcov2 = 0.334*pi;    % arbitrary

lb1 = 1.4;  % arbitrary
lb2 = 1.8;  % arbitrary

%thbcov1 = 0.000*pi;
%thbcov2 = 0.500*pi;
%lb1 = 1.0;  % arbitrary
%lb2 = 1.0;  % arbitrary

bcov1(1) = lb1*cos(thbcov1); bcov1(2) = lb1*sin(thbcov1);
bcov2(1) = lb2*cos(thbcov2); bcov2(2) = lb2*sin(thbcov2);

%---
% bcon1 and bcon2  (contravariant)
%---

thbcon1 = thbcov2 - 0.5*pi;
thbcon2 = thbcov1 + 0.5*pi;

lc1 = 2.4; % arbitrary
lc2 = 1.2; % arbitrary

%lc1 = 1.0; % arbitrary
%lc2 = 1.0; % arbitrary

bcon1(1) = lc1*cos(thbcon1); bcon1(2) = lc1*sin(thbcon1);
bcon2(1) = lc2*cos(thbcon2); bcon2(2) = lc2*sin(thbcon2);

%---
% projections
%---

omg(1) = bcov1*bcon1';
omg(2) = bcov2*bcon2';

%---
% compute covmet
%---

covmet(1,1) = bcov1*bcov1';
covmet(1,2) = bcov1*bcov2';
covmet(2,1) = bcov2*bcov1';
covmet(2,2) = bcov2*bcov2';

%---
% compute conmet
%---

conmet(1,1) = bcon1*bcon1';
conmet(1,2) = bcon1*bcon2';
conmet(2,1) = bcon2*bcon1';
conmet(2,2) = bcon2*bcon2';

%---
% concon and covcov components of the identity matrix
%---

for i=1:2
 for j=1:2
   Iconcon(i,j) = conmet(i,j)/(omg(i)*omg(j));
   Icovcov(i,j) = covmet(i,j)/(omg(i)*omg(j));
 end
end

%---
% four matrix bases
%---

for i=1:2
 for j=1:2

  Bconcov11(i,j) = bcon1(i)*bcov1(j);
  Bconcov12(i,j) = bcon1(i)*bcov2(j);
  Bconcov21(i,j) = bcon2(i)*bcov1(j);
  Bconcov22(i,j) = bcon2(i)*bcov2(j);

  Bcovcon11(i,j) = bcov1(i)*bcon1(j);
  Bcovcon12(i,j) = bcov1(i)*bcon2(j);
  Bcovcon21(i,j) = bcov2(i)*bcon1(j);
  Bcovcon22(i,j) = bcov2(i)*bcon2(j);

  Bcovcov11(i,j) = bcov1(i)*bcov1(j);
  Bcovcov12(i,j) = bcov1(i)*bcov2(j);
  Bcovcov21(i,j) = bcov2(i)*bcov1(j);
  Bcovcov22(i,j) = bcov2(i)*bcov2(j);

  Bconcon11(i,j) = bcon1(i)*bcon1(j);
  Bconcon12(i,j) = bcon1(i)*bcon2(j);
  Bconcon21(i,j) = bcon2(i)*bcon1(j);
  Bconcon22(i,j) = bcon2(i)*bcon2(j);

 end
end

%---
% identities
%---

Identity1 =  Iconcon(1,1)*Bcovcov11 + Iconcon(1,2)*Bcovcov12 ...
           + Iconcon(2,1)*Bcovcov21 + Iconcon(2,2)*Bcovcov22;

Identity2 =  Icovcov(1,1)*Bconcon11 + Icovcov(1,2)*Bconcon12 ...
           + Icovcov(2,1)*Bconcon21 + Icovcov(2,2)*Bconcon22;

Identity3 =  1/omg(1)*Bconcov11 + 1/omg(2)*Bconcov22;

Identity4 =  1/omg(1)*Bcovcon11 + 1/omg(2)*Bcovcon22;


[Identity1 Identity2 Identity3 Identity4]

