clear all
close all

%---
% specify a matrix
%---

T = [ 1.1, 2.1;
      0.4, 3.6];

%---
% compute eigenvectors and eigenvalues
%---

[EIG,  LAM] = eig(T);
[EIGT, LAM] = eig(T');

lam(1) = LAM(1,1);
lam(2) = LAM(2,2);

%----------
% bcov1 and bcov2 (covariant)
%----------

fc1 = 2.3; % arbitrary
fc2 = 1.4; % arbitrary

bcov1(1) = fc1*EIG(1,1);
bcov1(2) = fc1*EIG(2,1);
bcov2(1) = fc2*EIG(1,2);
bcov2(2) = fc2*EIG(2,2);

%---
% bcon1 and bcon2  (contravariant)
%---

fc1 =-0.7; % arbitrary
fc2 = 2.4; % arbitrary

bcon1(1) = fc1*EIGT(1,1);
bcon1(2) = fc1*EIGT(2,1);
bcon2(1) = fc2*EIGT(1,2);
bcon2(2) = fc2*EIGT(2,2);

%---
% projections omega(1) and omega(2)
%---

omg(1) = bcov1*bcon1';
omg(2) = bcov2*bcon2';

%---
% con-cov components
%---

Tnv(1,1) = bcon1*T*bcov1'/(omg(1)*omg(1));
Tnv(1,2) = bcon1*T*bcov2'/(omg(1)*omg(2));
Tnv(2,1) = bcon2*T*bcov1'/(omg(2)*omg(1));
Tnv(2,2) = bcon2*T*bcov2'/(omg(2)*omg(2));

%---
% cov-con components
%---

Tvn(1,1) = bcov1*T*bcon1'/(omg(1)*omg(1));
Tvn(1,2) = bcov1*T*bcon2'/(omg(1)*omg(2));
Tvn(2,1) = bcov2*T*bcon1'/(omg(2)*omg(1));
Tvn(2,2) = bcov2*T*bcon2'/(omg(2)*omg(2));

%---
% con-con components
%---

Tnn(1,1) = bcon1*T*bcon1'/(omg(1)*omg(1));
Tnn(1,2) = bcon1*T*bcon2'/(omg(1)*omg(2));
Tnn(2,1) = bcon2*T*bcon1'/(omg(2)*omg(1));
Tnn(2,2) = bcon2*T*bcon2'/(omg(2)*omg(2));

%---
% cov-cov components
%---

Tvv(1,1) = bcov1*T*bcov1'/(omg(1)*omg(1));
Tvv(1,2) = bcov1*T*bcov2'/(omg(1)*omg(2));
Tvv(2,1) = bcov2*T*bcov1'/(omg(2)*omg(1));
Tvv(2,2) = bcov2*T*bcov2'/(omg(2)*omg(2));

[Tnn, Tvv, Tnv, Tvn]

%---
% compute covmet (b)
%---

covmet(1,1) = bcov1*bcov1';
covmet(1,2) = bcov1*bcov2';
covmet(2,1) = bcov2*bcov1';
covmet(2,2) = bcov2*bcov2';

%---
% compute conmet (beta)
%---

conmet(1,1) = bcon1*bcon1';
conmet(1,2) = bcon1*bcon2';
conmet(2,1) = bcon2*bcon1';
conmet(2,2) = bcon2*bcon2';

%---
% in terms of eigenvalues
%---

for m=1:2
 for n=1:2
  den = omg(m)*omg(n);
  Tnv1(m,n) = 0.0;
  Tnn1(m,n) = lam(m)*conmet(m,n)/den;
  Tvv1(m,n) = lam(n)*covmet(m,n)/den;
  Tvn1(m,n) = covmet(1,m)*conmet(1,n)*lam(1)/omg(1) ...
            + covmet(2,m)*conmet(2,n)*lam(2)/omg(2);
  Tvn1(m,n) = Tvn1(m,n)/den;
 end
  Tnv1(m,m) = lam(m)/omg(m);
end

[Tnv Tnv1;
 Tnn Tnn1;
 Tvn Tvn1;
 Tvv Tvv1]

