clear all
close all

%==========
% compute contravariant from the covariant
% base vectors  
%==========

%---
% bcov1 and bcov2 (covariant)
%---

thbcov1 = 0.034*pi;    % arbitrary
thbcov2 = 0.334*pi;    % arbitrary

lb1 = 1.4;  % arbitrary
lb2 = 1.8;  % arbitrary

%thbcov1 = 0.000*pi;
%thbcov2 = 0.500*pi;
%lb1 = 1.0;  % arbitrary
%lb2 = 1.0;  % arbitrary

bcov1(1) = lb1*cos(thbcov1); bcov1(2) = lb1*sin(thbcov1);
bcov2(1) = lb2*cos(thbcov2); bcov2(2) = lb2*sin(thbcov2);

%---
% bcon1 and bcon2  (contravariant)
%---

thbcon1 = thbcov2 - 0.5*pi;
thbcon2 = thbcov1 + 0.5*pi;

lc1 = 2.4; % arbitrary
lc2 = 1.2; % arbitrary

%lc1 = 1.0; % arbitrary
%lc2 = 1.0; % arbitrary

bcon1(1) = lc1*cos(thbcon1); bcon1(2) = lc1*sin(thbcon1);
bcon2(1) = lc2*cos(thbcon2); bcon2(2) = lc2*sin(thbcon2);

%---
% projections
%---

omg(1) = bcov1*bcon1';
omg(2) = bcov2*bcon2';

%---
% compute covmet (b)
%---

covmet(1,1) = bcov1*bcov1';
covmet(1,2) = bcov1*bcov2';
covmet(2,1) = bcov2*bcov1';
covmet(2,2) = bcov2*bcov2';

%---
% compute conmet (beta)
%---

conmet(1,1) = bcon1*bcon1';
conmet(1,2) = bcon1*bcon2';
conmet(2,1) = bcon2*bcon1';
conmet(2,2) = bcon2*bcon2';

%---
% scaled matrices
%---

for i=1:2
 for j=1:2
   hatcovmet(i,j) = covmet(i,j)/omg(i);
   hatconmet(i,j) = conmet(i,j)/omg(i);
 end
end

%---
% confirm orthogonality
%---

[inv(hatcovmet) hatconmet]

%---
% confirm base vectors
%---

bcon1_conf = hatconmet(1,1)*bcov1 + hatconmet(2,1)*bcov2;
bcon2_conf = hatconmet(1,2)*bcov1 + hatconmet(2,2)*bcov2;

bcov1_conf = hatcovmet(1,1)*bcon1 + hatcovmet(2,1)*bcon2;
bcov2_conf = hatcovmet(1,2)*bcon1 + hatcovmet(2,2)*bcon2;

%---
% print
%---

[bcov1, bcov1_conf;
 bcov2, bcov2_conf;
 bcon1, bcon1_conf;
 bcon2, bcon2_conf]

%---
% an arbitrary vector
%---

v = [-2.9 1.3];

v1_con = v*bcon1'/omg(1);
v2_con = v*bcon2'/omg(2);

v1_cov = v*bcov1'/omg(1);
v2_cov = v*bcov2'/omg(2);

v1_cov_test = hatcovmet(1,1)*v1_con+hatcovmet(1,2)*v2_con;
v2_cov_test = hatcovmet(2,1)*v1_con+hatcovmet(2,2)*v2_con;

v1_con_test = hatconmet(1,1)*v1_cov+hatconmet(1,2)*v2_cov;
v2_con_test = hatconmet(2,1)*v1_cov+hatconmet(2,2)*v2_cov;

[v1_cov v1_cov_test;
 v2_cov v2_cov_test;
 v1_con v1_con_test;
 v2_con v2_con_test]
