clear all
close all

%==================================
% transformation of Cartesian bases
%==================================

%---
% first base
%---

thet1 = 0.0845*pi;  % arbitrary
thet2 = thet1 + 0.5*pi

e1(1) = cos(thet1); e1(2) = sin(thet1);
e2(1) = cos(thet2); e2(2) = sin(thet2);

%---
% second base (tilded)
%---

thett1 = 0.1234*pi;  % arbitrary
thett2 = thett1 + 0.5*pi;

et1(1) = cos(thett1); et1(2) = sin(thett1);
et2(1) = cos(thett2); et2(2) = sin(thett2);

%---
% transformation matrix
%---

Q(1,1) = et1(1)*e1(1) + et1(2)*e1(2);
Q(1,2) = et1(1)*e2(1) + et1(2)*e2(2);
Q(2,1) = et2(1)*e1(1) + et2(2)*e1(2);
Q(2,2) = et2(1)*e2(1) + et2(2)*e2(2);

E = [ e1(1) e2(1);
      e1(2) e2(2)];

Et = [ et1(1) et2(1);
       et1(2) et2(2)];

[Et E*Q']
[E  Et*Q]

et1_test = Q(1,1)*e1 + Q(1,2)*e2;
et2_test = Q(2,1)*e1 + Q(2,2)*e2;

[et1 et1_test]
[et2 et2_test]

