close all
clear all

%================================
% two bases rotated by thA and thB
% in a plane
%================================

thA = 0.034*pi;
thB = 0.245*pi;

eA1(1) = cos(thA); eA1(2)=sin(thA);
eA2(1)=-eA1(2); eA2(2)=eA1(1);

eB1(1) = cos(thB); eB1(2)=sin(thB);
eB2(1)=-eB1(2); eB2(2)=eB1(1);

%---
% plot
%---

figure(1)
hold on
plot([0, eA1(1)],[0,eA1(2)],'k')
plot([0, eA2(1)],[0,eA2(2)],'k')
plot([0, eB1(1)],[0,eB1(2)],'r')
plot([0, eB2(1)],[0,eB2(2)],'r')
axis equal

%---
% transformation matrix
%---

Q(1,1) = eB1(1)*eA1(1) + eB1(2)*eA1(2);
Q(1,2) = eB1(1)*eA2(1) + eB1(2)*eA2(2);
Q(2,1) = eB2(1)*eA1(1) + eB2(2)*eA1(2);
Q(2,2) = eB2(1)*eA2(1) + eB2(2)*eA2(2);

%---
% confirm orthogonality
%---

[Q' inv(Q)]

det(Q)

%---
% tensor
%---

T = [ 1 2;
      3 4];
%---
% A components
%---

TA(1,1) = eA1*T*eA1';
TA(1,2) = eA1*T*eA2';
TA(2,1) = eA2*T*eA1';
TA(2,2) = eA2*T*eA2';

%---
% B components
%---

TB(1,1) = eB1*T*eB1';
TB(1,2) = eB1*T*eB2';
TB(2,1) = eB2*T*eB1';
TB(2,2) = eB2*T*eB2';

%---
% print
%---

[Q TA TB Q*TA*Q']
