clear all
close all

%---
% constuct a 2x2 Cartesian base
%---

theta1 = 0.2345*pi;  % arbitrary
theta2 = theta1+0.5*pi;

e1(1) = cos(theta1); e1(2) = sin(theta1);
e2(1) = cos(theta2); e2(2) = sin(theta2);

for i=1:2
 for j=1:2
  B11(i,j) = e1(i)*e1(j);
  B12(i,j) = e1(i)*e2(j);
  B21(i,j) = e2(i)*e1(j);
  B22(i,j) = e2(i)*e2(j);
 end
end

%---
% display the base
%---

[B11 B12]
[B21 B22]

%---
% identity matrix
%---

B11+B22

