close all
clear all

%============================
% two Cartesian bases A and B
%============================

%----
% Cartesian base vectors A
% generated by random rotation
%----

th1 = rand*2.0*pi;
th2 = rand*2.0*pi;
th3 = rand*2.0*pi;

R1 = [1,0,0;
      0, cos(th1),sin(th1);
      0,-sin(th1),cos(th1)];

R2 = [cos(th2),0,-sin(th2);
      0,1,0;
      sin(th2),0,cos(th2)];

R3 = [ cos(th3),sin(th3),0;
      -sin(th3),cos(th3),0;
      0,0,1];

RA = R3*R2*R1;

for i=1:3
 eA1(i) = RA(i,1);
 eA2(i) = RA(i,2);
 eA3(i) = RA(i,3);
end

%----
% Cartesian base vectors B
% generated by random rotation
%----

th1 = rand*2.0*pi;
th2 = rand*2.0*pi;
th3 = rand*2.0*pi;

R1 = [1,0,0;
      0, cos(th1),sin(th1);
      0,-sin(th1),cos(th1)]

R2 = [cos(th2),0,-sin(th2);
      0,1,0;
      sin(th2),0,cos(th2)];

R3 = [ cos(th3),sin(th3),0;
      -sin(th3),cos(th3),0;
      0,0,1];

RB = R3*R2*R1;

for i=1:3
 eB1(i) = RB(i,1);
 eB2(i) = RB(i,2);
 eB3(i) = RB(i,3);
end

%---
% transformation matrix
%---

Q(1,1) = eB1(1)*eA1(1) + eB1(2)*eA1(2) + eB1(3)*eA1(3);
Q(1,2) = eB1(1)*eA2(1) + eB1(2)*eA2(2) + eB1(3)*eA2(3);
Q(1,3) = eB1(1)*eA3(1) + eB1(2)*eA3(2) + eB1(3)*eA3(3);

Q(2,1) = eB2(1)*eA1(1) + eB2(2)*eA1(2) + eB2(3)*eA1(3);
Q(2,2) = eB2(1)*eA2(1) + eB2(2)*eA2(2) + eB2(3)*eA2(3);
Q(2,3) = eB2(1)*eA3(1) + eB2(2)*eA3(2) + eB2(3)*eA3(3);

Q(3,1) = eB3(1)*eA1(1) + eB3(2)*eA1(2) + eB3(3)*eA1(3);
Q(3,2) = eB3(1)*eA2(1) + eB3(2)*eA2(2) + eB3(3)*eA2(3);
Q(3,3) = eB3(1)*eA3(1) + eB3(2)*eA3(2) + eB3(3)*eA3(3);

%Q = [ 1 2 3;
%      2 2 4;
%      3 4 8]
%Q = RA;
%Q = RB;
%Q= 2*Q;

%---
% confirm transformation
%---

for m=1:3
 for n=1:3
  for l=1:3
   ssm = 0.0;
   for i=1:3
     for j=1:3
       for k=1:3
       ijk = (i-j)*(j-k)*(k-i)/2;
       inc = Q(m,i)*Q(n,j)*Q(l,k)*ijk;
       ssm = ssm + inc;
       end
     end
   end
   mnl = (m-n)*(n-l)*(l-m)/2; % levi-civita symbol
   if(abs(mnl)>0.0001)
   [mnl ssm]
   end
  end
 end
end

