clear all
close all

%==================================
% Driver for ntegrating ODEs by RK4
%==================================

menu = 1;
N = 3;

time0 = 0.0;

x0(1) = 0.8;
x0(2) = 1.2;
x0(3) = 1.5;

Nstep = 64;
Dt = 0.02;

[time, solution] = RK4 ...
  ...
   (menu ...
   ,N ...
   ,Nstep ...
   ,Dt ...
   ,time0 ...
   ,x0 ...
   );

%---
% plot the solution
%---

figure(1)
hold on
plot(time,solution(1,:),'ko-')
plot(time,solution(2,:),'bs-')
plot(time,solution(3,:),'rd-')
box on
axis([0 1.5 0 10])
xlabel('t','fontsize',15)
ylabel('f_i','fontsize',15)
set(gca,'fontsize',15)
