function [t, xarray] = RK4 ...
  ...
   (menu ...
   ,N ...
   ,Nstep ...
   ,Dt ...
   ,time0 ...
   ,x0 ...
   )

%========================
% solve a system of N odes
% by RK4
%
% N: number of equations
% Nstep: number of steps
%========================

%---
% prepare
%---

 Dth = 0.5*Dt;

%---
% initial condition
%---

  for i=1:N
   x(i) = x0(i);
  end

%---
% integrate
%---

 time = time0;
 t(1) = time;

 for i=1:N
    xarray(i,1) = x0(i);
 end

 for i=1:Nstep

      for j=1:N
       xsave(j) = x(j);
      end

      f0 = RK4_vel (N,menu,x,time);

      for j=1:N
        x(j) = xsave(j) + Dth*f0(j);
      end

      f1 = RK4_vel (N,menu,x,time+Dth);

      for j=1:N
        x(j) = xsave(j) + Dth*f1(j);
      end

      f2 = RK4_vel (N,menu,x,time+Dth);

      for j=1:N
        x(j) = xsave(j) + Dt*f2(j);
      end

      f3 = RK4_vel (N,menu,x,time+Dt);

      for j=1:N
        vel = (f0(j) + 2.0*f1(j) + 2.0*f2(j) + f3(j))/6.0;
        x(j) = xsave(j) + Dt*vel;
      end

      for j=1:N
       xarray(j,i+1) = x(j);
      end

      time = time+Dt;
      t(i+1) = time;

 end

%---
% done
%---

return
