clear all
close all

x = [ 0.03 0.3 0.43 0.55 0.59 0.67 0.95];
y = [ 0.07 0.4 1.03 1.20 1.50 1.3  1.60];

S = size(x');

N = S(1)-1;

M = 1;

%---
% generate the matrix A
%---

for i=1:N+1
 for j=1:M+1
  A(i,j) = x(i)^(j-1);
 end
end

%---
% Moore--Penrose inverse
%---

MP = inv(A'*A)*A';
MP

P = pinv(A);
P

sol = P*y';

%---
% plot
%---

figure(1)
hold on
plot(x,y,'ko')
xlabel('x','fontsize',15)
ylabel('y','fontsize',15)
set(gca,'fontsize',15)
box on
axis([0 1 0 1.8])

if(M==1)
 a(1) = sol(2);
 a(2) = sol(1);
 yA = a(1)*x(1)+a(2);
 yB = a(1)*x(N+1)+a(2);
 plot([x(1),x(N+1)],[yA,yB],'k-')
end

