 function xx = bic_ode (Dell,Nstp)

%------------------------
% compute capsule profile
%------------------------

  global delta

%--------
% prepare
%--------

   Delh = 0.5*Dell;

%-------------------
% initial conditions
%-------------------

    x(1) = 0.0;
    x(2) = 0.0;
    x(3) = 0.0;
    x(4) = 1.0;

    for j=1:4
     xx(j,1) = x(j);
    end

%---------------------
% integrate by the RK4
%---------------------

   ell = 0.0;

   for i=1:Nstp

      for j=1:4
       xsave(j) = x(j);
      end

      g0 = bic_vel (x,ell);

      for j=1:4
        x(j) = xsave(j) + Delh*g0(j);
      end

      g1 = bic_vel (x,ell+Delh);

      for j=1:4
        x(j) = xsave(j) + Delh*g1(j);
      end

      g2 = bic_vel (x,ell+Delh);

      for j=1:4
        x(j) = xsave(j) + Dell*g2(j);
      end

      g3 = bic_vel (x,ell+Dell);

      for j=1:4
        vel = (g0(j)+2.0*g1(j)+2.0*g2(j)+g3(j))/6.0;
        x(j) = xsave(j) + Dell*vel;
      end

      ell = ell + Dell;

      for j=1:4
       xx(j,i+1) =x(j);
      end

   end  % over steps

%-----
% done
%-----

return
