clear all
close all

%=============================
% reconstruct biconcave shapes
% in terms of the curvature
%=============================

global delta

%---
% parameters
%---

Nstp = 32;
a = 1.0;  % equivalent radius;
L = a*pi;
Dell  = L/(2.0*Nstp);

%---
% prepare
%---

figure(1)
hold on
xlabel('x/a','fontsize',15)
ylabel('y/a','fontsize',15)
set(gca,'fontsize',15)

for iloop=1:6

if(iloop==1) delta = 0.0; end
if(iloop==2) delta = 0.5; end
if(iloop==3) delta = 1.0; end
if(iloop==4) delta = 1.5; end
if(iloop==5) delta = 2.0; end
if(iloop==6) delta = 2.3; end


%---
% integrate the ode
%---

xall = bic_ode (Dell,Nstp);

%---
% plot profile
%---

xshift = -xall(1,Nstp+1);

for i=1:Nstp+1
 xplot(i) = xall(1,i)+xshift;
 yplot(i) = xall(2,i);
end

figure(1)
plot( xplot, yplot,'k')
plot(-xplot,-yplot,'k')
plot(-xplot, yplot,'k')
plot( xplot,-yplot,'k')
axis equal
box on

end % of iloop

%---------------------
% calculate curvatures
% and their derivatives
% with respect to ell
%---------------------

  ell = 0.0;

  for i=1:Nstp+1

   % meridional curvature

   kell(i) = pi*(1.0 - delta*cos(2.0*ell))/L;

   x2 = xall(2,i);
   x3 = xall(3,i);
   x4 = xall(4,i);
   x5 = kell(i);

   % first and second detivaties (p) and (pp):

   kellp(i)  = delta * 2.0 * sin(2.0*ell);
   kellpp(i) = delta * 4.0 * cos(2.0*ell);

   % second curvature and derivatives:

   if(i == 1)
      kphi  (i) = kell(i);
      kphip (i) = 0.0;
      kphipp(i) = kellpp(i)/3.0;  % eq (8.3.7)
   else
      kphi(i) = -x3/x2;  % eq (8.3.3)
%     kphi(i) = Dsqrt(1.0D0-x4**2 )/x2
%     kphip(i) = (ksr(i)-kpr(i))/x2
      kphip (i) = x4*(kell(i)-kphi(i))/x2;  % eq (8.3.5)
      kphipp(i) = 0;
      kprpp(i) = x4/x2 * ( kellp(i)-kphip(i)-(kell(i)-kphi(i))/x2 ) ...
              + x5*x3*(kell(i)-kphi(i))/x2;
   end

     ellplot(i) = ell;

     ell = ell + Dell;

  end

figure(2)
hold on
plot(ellplot, kell,'k')
plot(L-ellplot, kell,'k')
plot(ellplot, kphi,'k--')
plot(L-ellplot, kphi,'k--')
plot(ellplot, kellp,'k-.')
plot(L-ellplot,-kellp,'k-.')
plot(ellplot, kellpp,'r-')
plot(L-ellplot, kellpp,'r-')
xlabel('l/a','fontsize',15)
ylabel('a \kappa_l','fontsize',15)
set(gca,'fontsize',15)
axis([0 L -10 10])
box on
