%---
clear all
close all
%---

%--------------------------------------------------
% Unsteady unidirectional flow in a circular tube 
% due to an oscillating pressure gradient.
%
% The pressure gradient is:
%
% dP/dx = - pgamp * sin(omega*time)
%--------------------------------------------------

nprof = 32;    % number of points for a profile
a = 1;        % channel width 
visc = 1.0;    % viscosity
rho = 1.0;     % density
pgamp = 1.0;      % pressure gradient
ell = 0.1;

omega =  0.01;   % angular frequency
omega =  2.0;   % angular frequency
omega =  8.0;   % angular frequency
omega =  0.1;   % angular frequency
omega = 16.0;   % angular frequency
omega =  1.0;   % angular frequency
omega =  4.0;   % angular frequency

step = a/nprof;

figure(1)
hold on

%---
 for iloop=1:8
%---

     if(iloop==1) ot=0.00*pi;
 elseif(iloop==2) ot=0.25*pi;
 elseif(iloop==3) ot=0.50*pi;
 elseif(iloop==4) ot=0.75*pi;
 elseif(iloop==5) ot=1.00*pi;
 elseif(iloop==6) ot=1.25*pi;
 elseif(iloop==7) ot=1.50*pi;
 elseif(iloop==8) ot=1.75*pi;
 end

 s=0;

 for i=1:nprof+1

  u = tube_crc_wom  ...
 ...
     (a ...
     ,visc ...
     ,rho ...
     ,pgamp ...
     ,omega ...
     ,ell ...
     ,ot ...
     ,s ...
     );

  Upoisc =  pgamp*a^2/(4.0*visc);

  xplot(i) = u/Upoisc;

  yplot(i) = s;

  s = s+step;

 end

 if(iloop==1)
  plot(xplot, yplot,'k--')
  plot(xplot,-yplot,'k--')
 elseif(iloop==2)
  plot(xplot, yplot,'k-.')
  plot(xplot,-yplot,'k-.')
 elseif(iloop==3)
  plot(xplot, yplot,'k:')
  plot(xplot,-yplot,'k:')
 else
  plot(xplot, yplot,'k')
  plot(xplot,-yplot,'k')
 end

%---
 end
%---

%xmin=-1; xmax=1.0;
 xmin = -1.2; xmax = 1.2;
 ymin = -1.2; ymax = 1.2;
 axis([xmin xmax ymin ymax])
 plot([0 0],[-a a],'c');
 plot([xmin xmax],[a a],'r','linewidth',4);
 plot([xmin xmax],[-a -a],'r','linewidth',4);
 xlabel('u_x/U','fontsize',15)
 ylabel('y/a','fontsize',15)
 set(gca,'fontsize',15)
 box

