function u = tube_crc_wom ...
  ...
  (a ...
  ,visc ...
  ,rho ...
  ,pgamp ...
  ,omega ...
  ,ell ...
  ,ot ...
  ,s ...
  )

%-------------------------------------------
% Unsteady unidirectional flow in a circular tube 
% due to an oscillating pressure gradient
% with wall slip
%
% The pressure gradient is:
%
% dp/dx = - pgamp * sin(omega*time)
%
% SYMBOLS:
% -------
%
% a:     tube radius
% omega: angular frequency
% ot:    omega*time
% visc:  fluid viscosity
% rho:   fluid density
% s:     sigma, distance from centerline
% u:     axial velocity
% ell:   slip length
%-------------------------------------------

%--------
% prepare
%--------

  nu  = visc/rho;  %   kinematic viscosity

  Wo = a*sqrt(omega/nu);
  soa = s/a;
  lambda = ell/a;

  Iopt = 1;     % need derivatives: ber0' and ber0'

%---
% denominator
%---

 [ber,bei,berp,beip] ...
  ...
  = ber_bei_0 (Iopt,Wo);

  denr =  ber + lambda*Wo*berp;
  deni = -bei - lambda*Wo*beip;

  dens = denr*denr + deni*deni;

  aar  = denr/dens;
  aai  =-deni/dens;

%---
% numerator
%---

 [ber,bei,berp,beip] ...
  ...
  = ber_bei_0 (Iopt,soa*Wo);

 bbr =  ber;
 bbi = -bei;

%----
% real part of the product
%---

 Ur = aar*bbr - aai*bbi - 1.0;
 Ui = aar*bbi + aai*bbr;

 cs = cos(ot);
 sn = sin(ot);

 u = pgamp*(cs*Ur + Ui*sn)/(rho*omega);

%-----
% done
%-----

return
