clear all

%----
% conform the properties of the quaternions
%----

im = sqrt(-1);

A = [3.0+1.0*im 4.0+0.3*im;    % typical
     5.0-0.4*im 6+2.0*im];

B = [1.0+1.0*im 3.0+0.4*im;
     2.0-0.8*im 7.0-1.3*im];

C = A*B;

q1A =     0.5*(A(1,1)+A(2,2));
q2A = -im*0.5*(A(1,1)-A(2,2));
q3A =     0.5*(A(1,2)-A(2,1));
q4A = -im*0.5*(A(1,2)+A(2,1));

q1B =     0.5*(B(1,1)+B(2,2));
q2B = -im*0.5*(B(1,1)-B(2,2));
q3B =     0.5*(B(1,2)-B(2,1));
q4B = -im*0.5*(B(1,2)+B(2,1));

q1AB = q1A*q1B - q2A*q2B - q3A*q3B - q4A*q4B;
q2AB = q1A*q4B + q2A*q3B - q3A*q2B + q4A*q1B;
q3AB = q1A*q2B + q2A*q1B + q3A*q4B - q4A*q3B;
q4AB = q1A*q3B - q2A*q4B + q3A*q1B + q4A*q2B;

q1C =     0.5*(C(1,1)+C(2,2));
q2C = -im*0.5*(C(1,1)-C(2,2));
q3C =     0.5*(C(1,2)-C(2,1));
q4C = -im*0.5*(C(1,2)+C(2,1));

[q1C q1AB;
 q2C q2AB;
 q3C q4AB;
 q4C q4AB;
]

%---
% determinants
%---

%----------

detA = q1A^2 + q2A^2 + q3A^2+q4A^2;
detB = q1B^2 + q2B^2 + q3B^2+q4B^2;
detC = q1C^2 + q2C^2 + q3C^2+q4C^2;

[detA, det(A)]
[detB, det(B)]
[detC, det(C)]
[detA*detB, detC]
%----------

%----------
% inverse of A
%----------

q1Ainv =  q1A/detA;
q2Ainv = -q2A/detA;
q3Ainv = -q3A/detA;
q4Ainv = -q4A/detA;

invA = [q1Ainv+im*q2Ainv, q3Ainv+im*q4Ainv;
       -q3Ainv+im*q4Ainv, q1Ainv-im*q2Ainv]
inv(A)

%----------
% projection
%----------

proj = q1A*q1B + q2A*q2B + q3A*q3B + q4A*q4B;
prog = 0.5*trace(B*inv(A))*det(A);
proq = 0.5*trace(A*inv(B))*det(B);
[proj prog proq]


%----------
% Hermitian of A
%----------

AA = [q1A+im*q4A, q2A+im*q3A;
     -q2A+im*q3A, q1A-im*q4A]

q1Acc =  conj(q1A);
q2Acc = -conj(q2A);
q3Acc = -conj(q3A);
q4Acc = -conj(q4A);

AAcc = [q1Acc+im*q4Acc, q2Acc+im*q3Acc;
       -q2Acc+im*q3Acc, q1Acc-im*q4Acc]

[q1A*q1B - q2A*q2B - q3A*q3B - q4A*q4B, q1C;
 q1A*q2B + q2A*q1B + q3A*q4B - q4A*q3B, q2C;
 q1A*q3B - q2A*q4B + q3A*q1B + q4A*q2B, q3C;
 q1A*q4B + q2A*q3B - q3A*q2B + q4A*q1B, q4C;
]

%---
% rotations
%---

theta = pi/0.345;
cs = cos(theta);
sn = sin(theta);

ROT = [cs  sn; ...
      -sn  cs];

q1Arot = cs*q1A-sn*q2A;
q2Arot = sn*q2A+cs*q2A;
q3Arot = cs*q3A+sn*q4A;
q4Arot =-sn*q3A+cs*q4A;

Arot = [q1Arot+im*q4Arot, q2Arot+im*q3Arot;
       -q2Arot+im*q3Arot, q1Arot-im*q4Arot]
A*ROT
