clear all
close all

%=======
% Solution of the Poisson equation
% by the Poisson integral in 2D
% by conformal mapping of a circular disc
%
% rho: radius of the circular disk in the zeta plane
%=======

im = sqrt(-1);
srt = sqrt(2);

rho = 1.0;

%---
% visualize the mapped contour
%---

N = 64;
Dphi = 2*pi/N;

for i=1:N+1
  phi = (i-1.0)*Dphi;
  xi(i) = rho*cos(phi);
  et(i) = rho*sin(phi);
  zeta = xi(i)+im*et(i);
  z = (1.0+1.0*im-0.2*zeta^2)*(1.0-0.1*zeta^4)*zeta/srt;
% z = sqrt(rho)*exp(im*phi/2.0);
% z = zeta/(1.0-0.5*zeta);
  x(i) = real(z);
  y(i) = imag(z);
end

figure(1)
hold on
axis equal
box on
xlabel('x','fontsize',15)
ylabel('y','fontsize',15)
set(gca,'fontsize',15)
plot(xi,et,'-ko')
plot(x,y,'-ro')

%---
% solution
%---

figure(2)
hold on
axis equal
box on
xlabel('x','fontsize',15)
ylabel('y','fontsize',15)
zlabel('f','fontsize',15)
set(gca,'fontsize',15)
view([30,15])

Nphi = 32;
Nsig = 14;
Dphi = 2.0*pi/Nphi;
Dsig = 1.0/Nsig;

Nphp = 4*32; % integration points

for j=2:Nsig+1

 sig = (j-1.0)*Dsig;

 for i=1:Nphi+1

   phi = (i-1)*Dphi;
   [x,y,f] = pintegral(Nphp,rho,sig,phi);

   if(j==Nsig+1)
    f = 0.0;
   end

   xsol(i,j) = x;
   ysol(i,j) = y;
   fsol(i,j) = 4.0*f;

 end

%plot3(x,y,f,'.k-')
surf(xsol,ysol,fsol)

end

