function [x,y,f] = pintegral(Nphp,rho,sigma,phi)

%=====================================================
% Compute the Poisson integral using the mid-point rule
%
% sigma, phi: evaluation point in the zeta domain
% x, y:       evaluation point in the z domain
% phip :      phi' (integration angle)
% Nphp :      number of integration divisions
% fp   :      particular solution
%=====================================================

%---
% prepare
%---

   im = sqrt(-1);

   Dphp = 2*pi/Nphp;

%---
% evaluation point in the z plane
% by mapping
%---

   zeta = sigma*exp(im*phi);
   z = (1.0+1.0*im-0.2*zeta^2)/sqrt(2)*(1.0-0.1*zeta^4)*zeta;
%  z = sqrt(rho)*exp(im*phi/2.0);
   x = real(z);
   y = imag(z);

%---
% integrate
%---

  fc = Dphp*(rho^2-sigma^2)/(2.0*pi);

  f = 0.0;

  for i=1:Nphp;
     phip = (i-0.5)*Dphp;
     zeta = rho*exp(im*phip);
     zp = (1.0+1.0*im-0.2*zeta^2)/sqrt(2)*(1.0-0.1*zeta^4)*zeta;
%    zp = sqrt(rho)*exp(im*phip/2.0);
     xp = real(zp);
     yp = imag(zp);
     fp = - 0.25*(xp^2+yp^2);
%    fp = - 0.5*yp^2;
     dp = rho^2+sigma^2-2*rho*sigma*cos(phi-phip);
     f = f - fp/dp;
  end

  f  = fc*f;

  fp = - 0.25*(x^2+y^2);
% fp = - 0.5*y^2;

  f  = f + fp;

%---
% done
%---

return
