clear all
close all

%=================================================
% Conformal mapping of a disk of radius rho
% to another domain
%
% rho: radius of the circular disk in the zeta plane
%=================================================

im = sqrt(-1);

rho1 = 1.0;
rho2 = 1.5;

%---
% visualize the mapped contour
%---

N = 32;
Dphi = 2*pi/N;

for i=1:N+1
  phi = (i-1.0)*Dphi;
  xi1(i) = rho1*cos(phi);
  et1(i) = rho1*sin(phi);
  zeta1 = xi1(i)+im*et1(i);
  xi2(i) = rho2*cos(phi);
  et2(i) = rho2*sin(phi);
  zeta2 = xi2(i)+im*et2(i);
  z1 = zeta1/(1.0-0.4*zeta1);
  z2 = zeta2/(1.0-0.4*zeta2);
  x1(i) = real(z1);
  y1(i) = imag(z1);
  x2(i) = real(z2);
  y2(i) = imag(z2);
end

%---
% plot
%---

figure(1)
hold on
axis equal
box on
xlabel('x','fontsize',15)
ylabel('y','fontsize',15)
set(gca,'fontsize',15)
plot(xi1,et1,'-ko')
plot(xi2,et2,'-ks')
plot(x1,y1,'-ro')
plot(x2,y2,'-rs')

