clear all
close all

%============================
% Grunwald-Letnikov derivative
% of a complex function
%
% z0: evaluation point
%============================

im = sqrt(-1);

alpha = 0.5;

z0 = 0.0;

zA = 20.0+20.0*im;

menu = 4;

kmax = 2*64;

%---
% prepare
%---

h = (z0-zA)/kmax;

%---
% compute the omegas
%---

ishift = 1;
omg(0+ishift) = 1;

  for k=1:kmax
    omg(k+ishift) = omg(k-1+ishift)*(k-alpha-1)/k;
  end

%---
% compute the derivative
%---

  glp = 0.0;

  for k=0:kmax
   z = z0-k*h;
   [f,fp,fpp,fppp] = riem_liouv_fnc(z,menu);
   glp = glp + omg(k+ishift)*f;
  end

 glp = glp/h^alpha;
 glp
