clear all
close all

%=========================================
% Compute the Cauchy fractional laplacian
% by contour integration
%
% THIS PROGRAM DOES NOT WORK
%=========================================

im = sqrt(-1);

N = 4*32; % points around the contour

x0 = 0.75;  % arbitrary
y0 = 0.00; % arbitrary

menu = 3;
menu = 1;
menu = 4;
menu = 2;
menu = 5;  % gaussian
menu = 6;  % gaussian momment

%---
% prepare
%---

%---
% generate contour nodes (arbitrary)
%---

xmin = -3.0;
xmax =  3.0;
dx = 2*xmax/N;

for i=1:N+1
 x(i) = xmin+(i-0.5)*dx;
 y(i) = 0.60+0.1*sin(2*pi*x(i))+0.220*exp(-x(i)^2);
 y(i) =-0.60+0.1*sin(2*pi*x(i))+0.220*exp(-x(i)^2);
 y(i) =-0.4;
end

%---
% plot
%---

figure(1)
hold on
plot(x,y,'-ko');
plot(x(1),y(1),'-r*');
plot(x0,y0,'ro');
xlabel('x','fontsize',15)
ylabel('y','fontsize',15)
set(gca,'fontsize',15)
axis equal
axis([-2.5 2.5 -1 1])
box on

%---
% contour node distances from x0
%---

for i=1:N+1
 Xr(i) = x(i)-x0;
 Yr(i) = y(i)-y0;
 Rr(i) = sqrt(Xr(i)^2+Yr(i)^2);
end

%---
% angles
%---

Tr(1) = acos(Xr(1)/Rr(1));
if(Yr(1)<0) Tr(1)=-Tr(1); end

for i=1:N
 crossprd = Xr(i)*Yr(i+1) - Xr(i+1)*Yr(i);
 den = Rr(i)*Rr(i+1);
 dt = asin(crossprd/den);
 innerprd = Xr(i)*Xr(i+1)+Yr(i)*Yr(i+1);
 if(innerprd<0)
  dt = dt*(pi/abs(dt)-1.0);
 end
 Tr(i+1) = Tr(i)+dt;
end

%---
% function evaluation
%---

for i=1:N+1
 z(i) = x(i)+im*y(i);
 [f(i),fp(i),fpp(i),fppp(i)] = fncc(z(i),menu);
end

nloop = 32;
alphamax = 3.0;

%========
%for iloop=1:nloop
 for iloop=1:1
%========

alpha = (iloop-1)*alphamax/(nloop-1);

alpha = 0.99;
alpha = -0.5;
alpha = -0.333;
alpha = 1.0;
alpha = 0.5;
alpha = 0.75;
alpha = 0.678;
alpha = 1.5;

%---
% integrand evaluation
%---

for i=1:N+1
 fc = 1.0;
 fc = 1.0 - exp((alpha+1)*im*pi);
 invp(i) = fc*exp(-(alpha+1)*im*Tr(i))/Rr(i)^(alpha+1);
end

%---
% integrate by the trapezoidal rule
%---

integral = 0.0;

for i=1:N
 integral = integral + 0.5*(f(i)  *invp(i) ...
                           +f(i+1)*invp(i+1)) ...
                           *(z(i+1)-z(i));
end

integral = gamma(alpha+1)*integral/(2*pi*im);

integral;

flapl = integral/cos(alpha*pi/2)

gaussian_0 = -1.0/sqrt(pi)*2^alpha*gamma(0.5*(1+alpha))

alphaplot(iloop) = alpha;
integralplot(iloop) = integral;

%==========
end
%==========


figure(2)
hold on
plot(x,real(invp),'k')
plot(x,imag(invp),'k--')
axis([-2 2 -20 20])

% fractional laplacian of the Gaussian for alpha=1.5

figure(3)
hold on
xlabel('x','fontsize',15)
ylabel('fractional laplacian','fontsize',15)
set(gca,'fontsize',15)

if(menu==5)
 [alphaga15, fraclapga15] = flga15;
 plot(alphaga15,fraclapga15,'k-')
 [alphaga0678, fraclapga0678] = flga0678;
  plot(alphaga0678,fraclapga0678,'k-')
elseif(menu==6)
 [alphagm15, fraclapgm15] = flgm15;
  plot(alphagm15,fraclapgm15,'k-')
 [alphagm0678, fraclapgm0678] = flgm0678;
  plot(alphagm0678,fraclapgm0678,'k-')
end
plot(x0,real(flapl),'ks')
plot(x0,imag(flapl),'ro')
plot(x0,real(flapl)+imag(flapl),'k*')
plot(x0,real(flapl)-imag(flapl),'bd')
box on
