function rli = rl_fint (bet,zA,z0,menu)

%==============================
% Compute the Riemann--Liouville
% fractional integral along a straight path
% by the trapezoidal rule
%
% int_zA_z0 f(z) /(z-z0)^bet d z
%==============================

im = sqrt(-1);

%---
% parameters
%---

nint = 4*8*64;

%---
% prepare
%---

x0 = real(z0);
y0 = imag(z0);

xA = real(zA);
yA = imag(zA);

[f0,fp0,fpp0,fppp0]  ...
     = fncc(z0,menu);

Dz = (z0-zA)/nint;

%---
% integrate by the mid-point rule
%---

intgrl = 0.0;

for i=1:nint

 z(i) = zA + (i-0.5)*Dz;

 x(i) = real(z(i));
 y(i) = imag(z(i));

 Xr(i) = x0-x(i);
 Yr(i) = y0-y(i);

 Rr(i) = sqrt(Xr(i)^2+Yr(i)^2);

 [f(i),fp(i),fpp(i),fppp(i)] ...
        = fncc (z(i),menu);

 intgrl = intgrl + (f(i)-f0)/Rr(i)^(1-bet);

end
%---

ang = acos(Xr(1)/Rr(1));
if(Yr(1)<0) ang=2*pi-ang; end

rli = intgrl*exp(-im*(1-bet)*ang)*Dz;

d = sqrt((x0-xA)^2+(y0-yA)^2);

rli = rli + f0/bet * d^bet * exp(im*bet*ang);

rli = rli/gamma(bet);

%---
% done
%---

return
