clear all
close all

%====================================
% computation of the Riemann--Liouville
% fractional derivative
%
% eps: numerical differentiation step
%====================================

im = sqrt(-1);

eps = 0.01*(1.6+0.3*im); % arbitrary

alpha =-0.333;
alpha = 1.5;
alpha = 0.5;

menu = 2;
menu = 4;

zA = 0.0+0.0*im;
z0 = 1.0+0.01*im;

z0 = 0.0;
zA = 1.0+0.9*im;

z0  = 0.3890 - 1.2000*im;  % arbitrary
zA  = 0.9269 + 0.3785*im;  % arbitrary


rlfder = rl_fder (alpha,zA,z0,eps,menu);
rlfder

%-----------------
% benchmark:
%
% menu = 4;
% alpha = 0.5;
% z0  = 0.3890 - 1.2000*im;
% zA  = 0.9269 + 0.3785*im;  % arbitrary
%
cauchy_for_alpha_one_half = -0.3062 + 1.2318*im
%-----------------

%---
% Gr"unwald--Letnikov derivative
%---

  Idogl = 0;
  Idogl = 1;

  if(Idogl==1)

  kmax = 1*32;

  h = (z0-zA)/kmax;

  ishift = 1;

  omg(0+ishift) = 1;

  for k=1:kmax
    omg(k+ishift) = omg(k-1+ishift)*(k-alpha-1)/k;
  end

  glp = 0.0;

  for k=0:kmax
   z = z0-k*h;
   [f,fp,fpp,fppp] = fncc(z,menu);
   glp = glp + omg(k+ishift)*f;
  end

%  glp = glp/h^alpha;

  ang = acos(real(h)/abs(h));
  if(imag(h)<0) ang = 2*pi - ang; end

  glp = glp/abs(h)^alpha * exp(-im*alpha*ang);

 glp

 end

