function rlip = rl_fder (alpha,zA,z0,eps,menu)

%====================================
% computation of the Riemann--Liouville
% fractional derivative
%
% eps: numerical differentiation step
%====================================

if(alpha<0)

 bet = -alpha;
 rlip = rl_fint (bet,zA,z0,menu);

elseif(alpha >= 0 & alpha < 1)

 bet = 1.0-alpha;
 rli_2 = rl_fint (bet,zA,z0+eps,menu);
 rli_1 = rl_fint (bet,zA,z0-eps,menu);
 rlip = (rli_2-rli_1)/(2*eps);

elseif(alpha >= 1 & alpha < 2)

 bet = 2.0-alpha;
 rli_0 = rl_fint (bet,zA,z0,menu);
 rli_1 = rl_fint (bet,zA,z0-eps,menu);
 rli_2 = rl_fint (bet,zA,z0+eps,menu);
 rlip = (rli_2 - 2*rli_0 + rli_1)/eps^2;

elseif(alpha >= 2 & alpha < 3)

 bet = 3.0-alpha;
 rli_A = rl_fint (bet,zA,z0-2*eps,nint,menu);
 rli_1 = rl_fint (bet,zA,z0-eps,nint,menu);
 rli_2 = rl_fint (bet,zA,z0+eps,nint,menu);
 rli_B = rl_fint (bet,zA,z0+2*eps,nint,menu);
 rlip = (-rli_A + 2*rli_1 - 2*rli_2 + rli_B)/(2*eps^3);

else

 disp('rl_fder: this choice of alpha not yet implemented')

end

%---
% done
%---

return
