function  [f,fp,fpp,fppp] = fncc(z,menu)

%=========================================
% evaluation of a complex function, f,
% its first, second, and third derivatives
%
% all functions implemented are arbitrary
%=========================================

  im = sqrt(-1);

  if(menu==1)
  
   dz = z - 2.3 - 3.2*im;
   f = 1/dz;
   fp = -1/dz^2;
   fpp = 2/dz^3;
   fppp =-6/dz^4;

  elseif(menu==2)

   a = 0.48;

   f = sin(a*z);
   fp = a*cos(a*z);
   fpp = -a*a*f;
   fppp = -a*a*a*fp;

  elseif(menu==3)

   f = z^3;
   fp = 3.0*z^2;
   fpp = 6.0*z;
   fppp = 6.0;

  elseif(menu==4)

   a = 1.0;
   f = exp(a*z);
   fp = a*exp(a*z);
   fpp = a*a*exp(a*z);
   fppp = a*a*a*exp(a*z);

  elseif(menu==5)

   t = exp(-z^2);
   f = t;
   fp = -2*z*t;
   fpp = 2*(2*z^2-1)*t;
   fppp = 4*z*(3-2*z^2)*t;

  elseif(menu==6)

   t = exp(-z^2);
   f = z*t;
   fp = (1-2.0*z^2)*t;
   fpp = 2.0 * z*(2.0*z^2-3.0)*t;
   fppp = 2.0 * (4.0*z^4-12.0*z^2+3.0)*t;

  end

return
