clear all
close all

%===============================
% Compute the Cauchy fractional
% integral or derivative 
% by contour integration
% around a specified contour
%===============================

im = sqrt(-1);

N = 2*8*32; % points around the contour

x0 = 0.389;  % arbitrary
y0 =-1.2; % arbitrary

menu = 3;
menu = 1;
menu = 2;
menu = 4;

%---
% prepare
%---

z0 = x0+im*y0;

%---
% generate contour nodes (arbitrary)
%---

dthet = 2*pi/N;

thetoff =-0.734*pi;  % arbitrary
thetoff = 0.1234*pi;  % arbitrary

for i=1:N+1
 theta(i) = (i-1)*dthet + thetoff;
 r = 1.0 + 0.5*sin(theta(i))^2 - 1.3*sin(theta(i))^3;  % arbitrary
 x(i) = r*cos(theta(i));
 y(i) = r*sin(theta(i));
end

%---
% plot
%---

figure(1)
hold on
plot(x,y,'-ko');
plot(x(1),y(1),'-r*');
plot([x0,x(1)],[y0,y(1)],'--k');
plot(x0,y0,'ro');
xlabel('x','fontsize',15)
ylabel('y','fontsize',15)
set(gca,'fontsize',15)
axis equal
axis([-1.5 1.5 -3 1])
box on

%---
% contour node distances from x0
%---

for i=1:N+1
 Xr(i) = x(i)-x0;
 Yr(i) = y(i)-y0;
 Rr(i) = sqrt(Xr(i)^2+Yr(i)^2);
end

%---
% angles
%---

Tr(1) = acos(Xr(1)/Rr(1));
if(Yr(1)<0) Tr(1)=-Tr(1); end

for i=1:N
 crossprd = Xr(i)*Yr(i+1) - Xr(i+1)*Yr(i);
 den = Rr(i)*Rr(i+1);
 dt = asin(crossprd/den);
 innerprd = Xr(i)*Xr(i+1)+Yr(i)*Yr(i+1);
 if(innerprd<0)
  dt = dt*(pi/abs(dt)-1.0);
 end
 Tr(i+1) = Tr(i)+dt;
end

%---
% function evaluation
%---

for i=1:N+1
 z(i) = x(i)+im*y(i);
 [f(i),fp(i),fpp(i),fppp(i)] = fncc(z(i),menu);
end

nloop = 32;
alphamax = 3.0;

%========
%for iloop=1:nloop
 for iloop=1:1
%========

alpha = (iloop-1)*alphamax/(nloop-1);

alpha = 0.99;
alpha = -0.5;
alpha = -0.333;
alpha = 1.0;
alpha = 1.5;
alpha = 0.5;

%---
% integrand evaluation
%---

for i=1:N+1
 invp(i) = exp(-(alpha+1)*im*Tr(i))/Rr(i)^(alpha+1);
end

%---
% integrate by the trapezoidal rule
%---

integral = 0.0;

for i=1:N
 integral = integral + 0.5*(f(i)  *invp(i) ...
                           +f(i+1)*invp(i+1)) ...
                           *(z(i+1)-z(i));
end

integral = gamma(alpha+1)*integral/(2*pi*im);

alphaplot(iloop) = alpha;
integralplot(iloop) = integral;

integral

%==========
end
%==========

[f0,fp0,fpp0,fppp0] = fncc(z0,menu);
f0_fp0_fpp0_fppp0 = [f0;fp0;fpp0;fppp0]

%---
% plot
%---

figure(2)
hold on
xlabel('\alpha','fontsize',15)
ylabel('f^{(\alpha)}','fontsize',15)
set(gca,'fontsize',15)
plot(alphaplot,real(integralplot),'k-')
plot(alphaplot,imag(integralplot),'r--')
plot([0],real(f0),'k*')
plot([0],imag(f0),'r*')
plot([1],real(fp0),'k*')
plot([1],imag(fp0),'r*')
plot([2],real(fpp0),'k*')
plot([2],imag(fpp0),'r*')
plot([3],real(fppp0),'k*')
plot([3],imag(fppp0),'r*')
box on

jumparg = exp(-2*pi*alpha*im)-1;
jumpinvp = jumparg*invp(1);
jumpR = real(jumpinvp);
jumpI = imag(jumpinvp);

figure(3)
hold on
plot(theta/pi,real(invp),'k')
plot(theta/pi+2,real(invp),'k')
plot(theta/pi-2,real(invp),'k')
plot(theta/pi,imag(invp),'k--')
plot(theta/pi+2,imag(invp),'k--')
plot(theta/pi-2,imag(invp),'k--')

plot([theta(1)/pi+0,theta(1)/pi+0] ...
    ,[real(invp(1)),real(invp(1))+jumpR],'--or')
plot([theta(1)/pi+0,theta(1)/pi+0] ...
    ,[imag(invp(1)),imag(invp(1))+jumpI],'--or')
plot([theta(1)/pi+2,theta(1)/pi+2] ...
    ,[real(invp(1)),real(invp(1))+jumpR],'--or')
plot([theta(1)/pi+2,theta(1)/pi+2] ...
    ,[imag(invp(1)),imag(invp(1))+jumpI],'--or')

%plot(theta,real(f),'k')
%plot(theta+2*pi,real(f),'k')
%plot(theta,imag(f),'r')
%plot(theta+2*pi,imag(f),'r')
%plot(theta,imag(f),'r')
%plot(theta+2*pi,imag(f),'r')

axis([0 3 -1.5 1])
xlabel('arg(z-z_0)/\pi','fontsize',15)
ylabel('1/(z-z_0)^{\alpha+1}','fontsize',15)
set(gca,'fontsize',15)
box on
