clear all
close all

%========================
% Confirm the Cauchy
% differentiation formula
%========================

n = 1.5; % differentiation order
n = 2.5; % differentiation order
n = 0.5; % differentiation order
n = 3; % differentiation order
n = 1; % differentiation order
n = 0; % differentiation order
n = 2; % differentiation order

N = 4*32; % points around the contour

x0 = 0.389;  % arbitrary
y0 =-1.200; % arbitrary

menu = 3;
menu = 4;
menu = 1;
menu = 2;

%---
% prepare
%---

im = sqrt(-1);

z0 = x0+im*y0;

%---
% generate contour nodes (arbitrary)
%---

dthet = 2*pi/N;

thetoff = 0.1234*pi;

for i=1:N+1
 theta(i) = (i-1)*dthet + thetoff;
 r = 1.0 + 0.5*sin(theta(i))^2 - 1.3*sin(theta(i))^3;
 x(i) = r*cos(theta(i));
 y(i) = r*sin(theta(i));
end

%---
% plot
%---

figure(1)
hold on
plot(x,y,'-ko');
plot(x(1),y(1),'-r*');
plot(x0,y0,'ro');
plot([x0,x(1)],[y0,y(1)],'--k');
axis equal
axis([-1.5 1.5 -3 1])
xlabel('x','fontsize',15)
ylabel('y','fontsize',15)
set(gca,'fontsize',15)
box on

%---
% contour node distance from z0
%---

for i=1:N+1
 Xr(i) = x(i)-x0;
 Yr(i) = y(i)-y0;
 Rr(i) = sqrt(Xr(i)^2+Yr(i)^2);
end

%---
% angles
%---

Tr(1) = acos(Xr(1)/Rr(1));

if(Yr(1)<0) Tr(1)=-Tr(1); end

for i=1:N
 crossprd = Xr(i)*Yr(i+1) - Xr(i+1)*Yr(i);
 den = Rr(i)*Rr(i+1);
 dt = asin(crossprd/den);
 innerprd = Xr(i)*Xr(i+1)+Yr(i)*Yr(i+1);
 if(innerprd<0)
  dt = dt*(pi/abs(dt)-1.0);
 end
 Tr(i+1) = Tr(i)+dt;
end

%---
% function and integrand evaluation
%---

for i=1:N+1
 invp(i) = exp(-(n+1)*im*Tr(i))/Rr(i)^(n+1);
 z(i) = x(i)+im*y(i);
 [f(i),fp(i),fpp(i),fppp(i)] = fncc(z(i),menu);
end

%---
% integrate by the trapezoidal rule
%---

integral = 0.0;

for i=1:N
 integral = integral + 0.5*(f(i)  *invp(i) ...
                           +f(i+1)*invp(i+1)) ...
                           *(z(i+1)-z(i));
end

integral = gamma(n+1)*integral/(2*pi*im);

%---
% display
%---

integral

[f0,fp0,fpp0,fppp0] = fncc(z0,menu);
n
f0_fp0_fpp0_fppp0 = [f0;fp0;fpp0;fppp0]

%-----
% plot the kernel
%-----

figure(2)
hold on
plot(theta,real(f),'k')
plot(theta+2*pi,real(f),'k')
plot(theta,imag(f),'r')
plot(theta+2*pi,imag(f),'r')
plot(theta,real(invp),'b')
plot(theta+2*pi,real(invp),'b')
plot(theta,imag(invp),'c')
plot(theta+2*pi,imag(invp),'c')
plot(theta,imag(f),'r')
plot(theta+2*pi,imag(f),'r')
xlabel('\theta','fontsize',15)
ylabel('kernel','fontsize',15)
set(gca,'fontsize',15)
box on
