function [a,b,Sum] = riemzet(s,N,p,kmax,tol);

%=================================
% Compute the Riemann zeta function
%
% sum_1^infty 1/i^s
%
% by Aitken extrapolation
%=================================

%---
% prepare
%---

L = 0;
M = N;

Sum = 0.0;

%-------------
for k=1:kmax+2
%-------------

   for i=L+1:M

    term = 1.0/i^s;
    Sum = Sum + term;

   end

   b(k) = Sum - 0.5/M^s;

   if(k>2)
    a(k-1) = (b(k-2)*b(k)-b(k-1)*b(k-1))/(b(k)-2.0*b(k-1)+b(k-2));
   end

   if(k>3)
   %---
   if(abs(a(k-1)-a(k-2))<tol)
    Sum = a(k-1);
    kmax = k-2;
    break;
   end
   %---
   end

   L = M;
   M = M*p;

%---
end
%--

Sum = a(k-1);

%---
% done
%---

return
