clear all
close all

%====================================
% driver for the right Riemann--Louiville
% fractional integral
%====================================

menu = 4;

xB = 2.0;

x = 1.0;

betamin = 0.01;
betamax = 2.00;

nint = 4*16;

%---
% loop over beta
%---

nloop = 64;
dbet = (betamax-betamin)/nloop;

for iloop = 1:nloop+1
 bet = betamin+(iloop-1)*dbet;
 rli = rl_fintr (bet,xB,x,nint,menu);
 betplot(iloop) = bet;
 rliplot(iloop) = rli;
end

%---
% plot
%---

figure(1)
hold on
plot(betplot,rliplot,'k');
plot([0.0],[exp(x)],'ro');
plot([1.0],[exp(xB)-exp(x)],'ro');
plot([2.0],[exp(x)],'ro');
set(gca,'fontsize',15)
xlabel('\beta','fontsize',15)
ylabel('I^{(\beta)}','fontsize',15)
box on
