function rli = rl_fintr (bet,xB,x,nint,menu)

%=============================================
% compute the right Riemann--Liouville integral
%
% int_x^xB f(x) /(xi-x)^bet d xi
%
%=============================================

%---
% prepare
%---

[f,fp,fpp,fppp] = fnc(x,menu);

Dx = (xB-x)/nint;

%---
% integrate by the mid-point rule
%---

intgrl = 0.0;

for i=1:nint

 xi(i) = x + (i-0.5)*Dx;
 xr(i) = xi(i)-x;

 [fxi(i),fxip(i),fxipp(i),fxippp(i)]  ...
        = fnc(xi(i),menu);

 intgrl = intgrl + (fxi(i)-f)/xr(i)^(1.0-bet);

end
%---

rli = intgrl*Dx;
rli = rli + f/bet * (xB-x)^bet;
rli = rli/gamma(bet);

%---
% done
%---

return
