clear all
close all

%====================================
% driver for the Riemann--Louiville
% fractional integral
%====================================

xA = 0.0;

x = 1.5;
x = 1.0;

menu = 4; % exponential

betamin = 0.01;
betamax = 2.00;
nint = 4*16;

%---
% loop over beta
%---

nloop = 64;
dbet = (betamax-0.01)/nloop;

for iloop = 1:nloop+1

 bet = betamin+(iloop-1)*dbet;

 rli = rl_fint(bet,xA,x,nint,menu);

 betplot(iloop) = bet;
 rliplot(iloop) = rli;

end

%---
% plot
%---

figure(1)
hold on
plot(betplot,rliplot,'k');
plot([0.0],[exp(x)],'ro');
plot([1.0],[exp(x)-1],'ro');
plot([2.0],[exp(x)-2],'ro');
set(gca,'fontsize',15)
xlabel('\beta','fontsize',15)
ylabel('I^{(\beta)}','fontsize',15)
box on
