function rli = rl_fint (bet,xA,x,nint,menu)

%========================================
% compute the Riemann--Liouville integral
%
% int_xA_x f(xi) /(x-xi)^bet d xi
%
% nint: integration intervals
%========================================

%---
% prepare
%---

[f,fp,fpp,fppp] = fnc(x,menu);

Dx = (x-xA)/nint;

%---
% integrate by the mid-point rule
%---

intgrl = 0.0;

for i=1:nint

 xi(i) = xA + (i-0.5)*Dx;
 xr(i) = x-xi(i);

 [fxi(i),fxip(i),fxipp(i),fxippp(i)]  ...
        = fnc(xi(i),menu);

 intgrl = intgrl + (fxi(i)-f)/xr(i)^(1.0-bet);

end
%---

rli = intgrl*Dx;
rli = rli + f/bet * (x-xA)^bet;
rli = rli/gamma(bet);

%---
% done
%---

return
