clear all
close all

%====================================
% driver for the Riemann--Louiville
% right fractional integral
%====================================

eps = 0.01; % arbitrary

alpha = 0.5;
alpha = 1.5;

menu = 10;
menu = 4; % exponential
menu = 5; % Gaussian

x0 = 1.0;  % arbitrary
xB = 2.0;  % arbitrary

x0 = 0.0;  % arbitrary
xB = 2.0;  % arbitrary

nint = 4*16;

nloop = 16;
nloop = 32;
nloop = 64;

alphamin = 0.01;
alphamax = 2.99;

dalpha = (alphamax-alphamin)/nloop;

%---
% loop over alpha
%---

for iloop = 1:nloop+1

 alpha = 0.01+(iloop-1)*dalpha;

 rlip = rl_fderr (alpha,xB,x0,eps,nint,menu);

 alphaplot(iloop) = alpha;
 rliplot(iloop) = rlip;

 %======
 %
 % Gr"unwald-Letnikov derivative
 % 

  Idogl = 0;
  Idogl = 1;

  if(Idogl==1)

  kmax = 32;
  kmax = 64;
  kmax = 16;

  glpf = gl_fderf (alpha,xB,x0,kmax,menu);
  glpfplot(iloop) = glpf;

  glpc = gl_fderc(alpha,2*x0-xB,x0,kmax,menu);
  glpcplot(iloop) = glpc;

  end

 %======
 
end

figure(1)
hold on
set(gca,'fontsize',15)
xlabel('\alpha','fontsize',15)
ylabel('f^{(\alpha)}','fontsize',15)
box on
plot(alphaplot,rliplot,'k');

if(Idogl==1)
 plot(alphaplot,glpfplot,'r--');
 plot(alphaplot,glpcplot,'k--');
end

[f0,fp0,fpp0,fppp0] = fnc(x0,menu);
plot([0.0],[f0],'ro');
plot([1.0],[-fp0],'ro');
plot([2.0],[fpp0],'ro');
plot([3.0],[-fppp0],'ro');
