function rlip = rl_fderr (alpha,xB,x,eps,nint,menu)

%====================================
% computation of the right Riemann--Liouville
% fractional derivative
%
% eps: numerical differentiation displacement
%====================================

if(alpha<0)

 bet = -alpha;
 rlip = rl_fintr (bet,xB,x,nint,menu);

elseif(alpha >= 0 & alpha < 1)

 bet = 1.0-alpha;
 rli_2 = rl_fintr (bet,xB,x+eps,nint,menu);
 rli_1 = rl_fintr (bet,xB,x-eps,nint,menu);
 rlip = (rli_2-rli_1)/(2*eps);
 rlip = - rlip;

elseif(alpha >= 1 & alpha < 2)

 bet = 2.0-alpha;
 rli_1 = rl_fintr (bet,xB,x-eps,nint,menu);
 rli_0 = rl_fintr (bet,xB,x,nint,menu);
 rli_2 = rl_fintr (bet,xB,x+eps,nint,menu);
 rlip = (rli_2 -2*rli_0 +rli_1)/eps^2;

elseif(alpha >= 2 & alpha < 3)

 bet = 3.0-alpha;
 rli_A = rl_fintr (bet,xB,x-2*eps,nint,menu);
 rli_1 = rl_fintr (bet,xB,x-eps,nint,menu);
 rli_2 = rl_fintr (bet,xB,x+eps,nint,menu);
 rli_B = rl_fintr (bet,xB,x+2*eps,nint,menu);
 rlip = (-rli_A + 2*rli_1 - 2*rli_2 + rli_B)/(2*eps^3);
 rlip = - rlip;

else

 disp('rl_fderr: this choice of alpha not yet implemented')

end

%---
% done
%---

return
