clear all
close all

eps = 0.01; % arbitrary

%====================================
% driver for the Riemann--Louiville
% fractional derivative
%====================================

menu = 5;  % Gaussian
menu = 4;  % exponential

x = 1.0;  % arbitrary
xA = 0.0;  % arbitrary

xA = 0.0;
x = 1.0;

xA = -1.0;
x = 0.0;

nint = 16;

nloop = 32;
nloop = 16;
nloop = 64;

alphamin = 0.01;
alphamax = 0.5;
alphamax = 2.99;

dalpha = (alphamax-alphamin)/nloop;

%---
% loop over alpha
%---

for iloop = 1:nloop+1

 alpha = alphamin+(iloop-1)*dalpha;

 rlip = rl_fder(alpha,xA,x,eps,nint,menu);

 alphaplot(iloop) = alpha;
 rliplot(iloop) = rlip;

 %======
 %
 % Gr"unwald-Letnikov derivative
 % 

  Idogl = 1;
  Idogl = 0;

  if(Idogl==1)

  kmax = 16;
  kmax = 64;
  kmax = 32;

  glp = gl_fder(alpha,xA,x,kmax,menu);

  glplot(iloop) = glp;

  glpf = gl_fderf(alpha,2*x-xA,x,kmax,menu);
  glpfplot(iloop) = glpf;

  glpc = gl_fderc(alpha,xA,x,kmax,menu);
  glpcplot(iloop) = glpc;

  end

 %======
 
end

figure(1)
hold on
set(gca,'fontsize',15)
xlabel('\alpha','fontsize',15)
ylabel('f^{(\alpha)}','fontsize',15)
box on

plot(alphaplot,rliplot,'k');

if(Idogl==1)
 plot(alphaplot,glplot,'k--');
%plot(alphaplot,glpfplot,'b--');
%plot(alphaplot,glpcplot,'r--');
end

[f0,fp0,fpp0,fppp0] = fnc(x,menu);
plot([0.0],[f0],'ro');
plot([1.0],[fp0],'ro');
plot([2.0],[fpp0],'ro');
plot([3.0],[fppp0],'ro');

