clear all
close all

%==============================
% compute the coefficients omega
% in three ways
%==============================

alpha = 1.55;
alpha = 1.99;
alpha = 0.55;

N = 2*32;

ishift =1;

%---
% recursion
%---

omg(0+ishift) = 1.0;
for k=1:N
 omg(k+ishift) = omg(k-1+ishift)*(k-alpha-1)/k;
end

%---
% gamma function, first method
%---

for k=0:N
 omg1(k+ishift) = gamma(k-alpha)/gamma(-alpha)/gamma(k+1);
end

%---
% gamma function, second method
%---

for k=0:N
 omg2(k+ishift) = (-1)^k* gamma(1+alpha)/gamma(alpha-k+1)/gamma(k+1);
end

%---
% they should be the same
%---

[omg' omg1' omg2']

%---
% prepare to plot
%---

figure(1)
hold on
set(gca,'fontsize',15)
xlabel('k','fontsize',15)
ylabel('\omega_k','fontsize',15)
axis([0 5 -2 2])
box on

figure(2)
hold on
set(gca,'fontsize',15)
xlabel('k','fontsize',15)
ylabel('d_k','fontsize',15)
axis([0 5 -1 2])
box on

%---
for iloop=1:7
%---

 if(iloop==1) alpha = 1.99; end
 if(iloop==2) alpha = 1.50; end
 if(iloop==3) alpha = 1.20; end
 if(iloop==4) alpha = 1.00; end
 if(iloop==5) alpha = 0.80; end
 if(iloop==6) alpha = 0.50; end
 if(iloop==7) alpha = 0.01; end

 omg(0+ishift) = 1.0;
 for k=1:N
  omg(k+ishift) = omg(k-1+ishift)*(k-alpha-1)/k;
 end

 % tests
 xi = 0.534;
 xi = 0.800;
 xi = 0.000;
 xi =-0.200;
 sun = 0.0;
 for k=0:N
  sun = sun+omg(k+ishift)*xi^k;
 end
 [ alpha sum(omg);
  (1-xi)^alpha sun]

 cf = - 0.5/cos(alpha*pi/2);

 for k=0:N
  plotk(k+ishift) = k; 
  dc(k+ishift) = cf*omg(k+ishift);
 end

 dc(0+ishift) = 2.0*dc(0+ishift);

 figure(1)
 if(iloop==1)
  plot(plotk,omg,'r*-')
 elseif(iloop==7)
  plot(plotk,omg,'ko-')
 else
  plot(plotk,omg,'ko-')
 end

 figure(2)
 if(iloop==1)
  plot(plotk,dc,'ro-')
 elseif(iloop==6)
  plot(plotk,dc,'k*-')
 else
  plot(plotk,dc,'ko--')
 end

%---
end
%---

%---
% Gaussian signal
%---

xa = 2.0;

Dx = xa/N;

for i=1:2*N+1
 x(i) = -xa+(i-1)*Dx;
 y(i) = exp(-x(i)^2)+0.1*(rand-0.5);
end

figure(3)
hold on
plot(x,y,'ok')
set(gca,'fontsize',15)
xlabel('x','fontsize',15)
ylabel('y','fontsize',15)
box on

