function glp = gl_flap (alpha,x,h,kmax,menu)

%===============================
% Evaluate the fractional Laplacian
% based on the Grunwald--Letnikov
% fractional derivatives
%===============================

  ishift = 1;
  omg(ishift) = 1;
  for k=1:kmax
    omg(k+ishift) = omg(k-1+ishift)*(k-alpha-1)/k;
  end

  glp = 0.0;

  for k=0:kmax
   [f,fp,fpp,fppp] = fnc(x-k*h,menu);
   glp = glp + omg(k+ishift)*f;
   [f,fp,fpp,fppp] = fnc(x+k*h,menu);
   glp = glp + omg(k+ishift)*f;
  end

  glp = glp/h^alpha;
  glp = - glp/(2.0*cos(alpha*pi/2));

%---
% done
%---

return
