function glp = gl_fderf(alpha,xB,x,kmax,menu)

%======================================
% evaluate the forward Grunwald--Letnikov
% fractional derivative
%======================================

  h = (xB-x)/kmax;

%---
% compute omega_k
%---

  ishift = 1;

  omg(ishift) = 1;

  for k=1:kmax
    omg(k+ishift) = omg(k-1+ishift)*(k-alpha-1)/k;
  end

%---
% compute the fractional derivative
%---

  glp = 0.0;

  for k=0:kmax
   [f,fp,fpp,fppp] = fnc(x+kh,menu);
   glp = glp + omg(k+ishift)*f;
  end

  glp = glp/h^alpha;

% fc = cos(alpha*pi)
% glp = fc*glp;

%---
% done
%---

return
